@extends('layouts.print_a4')

@php
    $isInput = $transaction->type == 'in';
    $title_ar = $isInput ? 'سند قبض نقدية' : 'سند صرف نقدية';
    $title_en = $isInput ? 'Receipt Voucher' : 'Payment Voucher';
@endphp

@section('title', $title_en . ' #' . $transaction->id)
@section('doc_title', $title_ar . ' (' . $title_en . ')')

@section('content')
    <div class="doc-meta">
        <div>رقم السند: <strong>{{ str_pad($transaction->id, 6, '0', STR_PAD_LEFT) }}</strong></div>
        <div>التاريخ: <strong>{{ $transaction->date->format('Y-m-d') }}</strong></div>
        <div>الحساب: <strong>{{ $transaction->treasury->name }}</strong></div>
    </div>

    <div style="margin: 40px 0; font-size: 18px; line-height: 2.5; border: 1px solid #ddd; padding: 20px;">
        {{ $isInput ? 'استلمنا من:' : 'يصرف لـ السيد:' }}
        <span style="border-bottom: 1px dotted #000; display: inline-block; min-width: 300px; font-weight: bold;">
            {{ $transaction->description }}
        </span>
        <br>
        مبلغ وقدره:
        <span style="border-bottom: 1px dotted #000; display: inline-block; min-width: 200px; font-weight: bold;">
            {{ number_format($transaction->amount, 2) }} ج.م
        </span>
        <br>
        وذلك مقابل:
        <span style="border-bottom: 1px dotted #000; display: inline-block; min-width: 400px;">
            {{ $transaction->description }}
        </span>
    </div>

    <div class="totals-section"
        style="width: 100%; border: 2px solid #000; padding: 15px; text-align: center; font-size: 22px; background: #f8f9fa;">
        القيمة: <strong>{{ number_format($transaction->amount, 2) }} ج.م (فقط لا غير)</strong>
    </div>

    <div class="signature-section">
        <div class="signature-box">
            توقيع المستلم
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            المحاسب
            <div class="signature-line"></div>
        </div>
        <div class="signature-box">
            يعتمد
            <div class="signature-line"></div>
        </div>
    </div>
@endsection