@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">{{ $treasury->name }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a
                            href="{{ route('accounting.treasuries.index') }}">{{ __('Treasuries') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $treasury->name }}</li>
                </ol>
            </nav>
        </div>
    </div>
    <div class="col-12 col-md-6 text-md-end">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#transactionModal">
            <i class="fas fa-plus-circle me-2"></i>{{ __('New Transaction') }}
        </button>
    </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-primary text-white">
                <div class="card-body p-4 text-center">
                    <h5 class="text-uppercase opacity-75">{{ __('Current Balance') }}</h5>
                    <h1 class="display-4 fw-bold mb-0">{{ number_format($treasury->balance, 2) }} <small
                            class="fs-4">{{ $treasury->currency }}</small></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">{{ __('Transaction History') }}</h5>
            <!-- Filters could go here -->
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Description') }}</th>
                            <th>{{ __('Ref. No') }}</th>
                            <th class="text-end">{{ __('Amount') }}</th>
                            <th>{{ __('User') }}</th>
                            <th class="text-center">{{ __('Voucher') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction->date->format('Y-m-d') }}</td>
                                <td>
                                    @if($transaction->type == 'in')
                                        <span class="badge bg-success"><i class="fas fa-arrow-down me-1"></i>
                                            {{ __('Deposit') }}</span>
                                    @else
                                        <span class="badge bg-danger"><i class="fas fa-arrow-up me-1"></i>
                                            {{ __('Withdrawal') }}</span>
                                    @endif
                                </td>
                                <td>
                                    {{ $transaction->description }}
                                    @if($transaction->model_type == 'App\Models\Invoice')
                                        <a href="{{ route('accounting.invoices.show', $transaction->model_id) }}"
                                            class="text-info ms-1"><i class="fas fa-link"></i></a>
                                    @endif
                                </td>
                                <td>{{ $transaction->ref_no ?? '-' }}</td>
                                <td class="text-end fw-bold {{ $transaction->type == 'in' ? 'text-success' : 'text-danger' }}">
                                    {{ $transaction->type == 'in' ? '+' : '-' }} {{ number_format($transaction->amount, 2) }}
                                </td>
                                <td>
                                    <small class="text-muted">{{ $transaction->user->name ?? 'System' }}</small>
                                </td>
                                <td class="text-center">
                                    <a href="{{ route('accounting.treasuries.vouchers.print', $transaction) }}" target="_blank"
                                        class="text-info">
                                        <i class="fas fa-print"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">{{ __('No transactions found.') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($transactions->hasPages())
            <div class="card-footer">
                {{ $transactions->links() }}
            </div>
        @endif
    </div>
    </div>

    <!-- Transaction Modal -->
    <div class="modal fade" id="transactionModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="{{ route('accounting.treasuries.transaction') }}" method="POST">
                @csrf
                <input type="hidden" name="treasury_id" value="{{ $treasury->id }}">
                <div class="modal-content bg-dark">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">{{ __('New Transaction') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Type') }} <span class="text-danger">*</span></label>
                            <div class="btn-group w-100" role="group">
                                <input type="radio" class="btn-check" name="type" id="typeIn" value="in" autocomplete="off"
                                    checked>
                                <label class="btn btn-outline-success" for="typeIn">{{ __('Deposit (Income)') }}</label>

                                <input type="radio" class="btn-check" name="type" id="typeOut" value="out"
                                    autocomplete="off">
                                <label class="btn btn-outline-danger" for="typeOut">{{ __('Withdrawal (Expense)') }}</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Amount') }} <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="amount" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Date') }} <span class="text-danger">*</span></label>
                            <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Description') }} <span class="text-danger">*</span></label>
                            <input type="text" name="description" class="form-control"
                                placeholder="{{ __('e.g. Electricity Bill, Cash Sale') }}" required>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Save Transaction') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection