@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div>
                <h2 class="fw-light">{{ __('Units & Measures') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Units') }}</li>
                    </ol>
                </nav>
            </div>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createUnitModal">
                <i class="fas fa-plus me-1"></i>{{ __('Add Unit') }}
            </button>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        <!-- Quantity Units -->
        <div class="col-lg-6">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary">
                    <h5 class="mb-0"><i class="fas fa-boxes me-2"></i>{{ __('Quantity Units') }}</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0 align-middle">
                            <thead>
                                <tr>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Short') }}</th>
                                    <th>{{ __('Base Unit') }}</th>
                                    <th>{{ __('Factor') }}</th>
                                    <th class="text-end">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($units->where('type', 'quantity') as $unit)
                                    <tr>
                                        <td class="fw-bold">{{ $unit->name }}</td>
                                        <td><span class="badge bg-secondary">{{ $unit->short_name ?? '-' }}</span></td>
                                        <td>{{ $unit->parent ? $unit->parent->name : '-' }}</td>
                                        <td>{{ $unit->conversion_factor ?? '-' }}</td>
                                        <td class="text-end">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                                                data-bs-target="#editUnitModal{{ $unit->id }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="{{ route('units.destroy', $unit) }}" method="POST" class="d-inline"
                                                onsubmit="return confirm('{{ __('Are you sure?') }}')">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>

                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editUnitModal{{ $unit->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content bg-dark text-white">
                                                <form action="{{ route('units.update', $unit) }}" method="POST">
                                                    @csrf @method('PUT')
                                                    <div class="modal-header border-secondary">
                                                        <h5 class="modal-title">{{ __('Edit Unit') }}</h5>
                                                        <button type="button" class="btn-close btn-close-white"
                                                            data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label class="form-label">{{ __('Name') }} <span
                                                                    class="text-danger">*</span></label>
                                                            <input type="text" name="name"
                                                                class="form-control bg-dark text-white border-secondary"
                                                                value="{{ $unit->name }}" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">{{ __('Short Name') }}</label>
                                                            <input type="text" name="short_name"
                                                                class="form-control bg-dark text-white border-secondary"
                                                                value="{{ $unit->short_name }}">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">{{ __('Type') }}</label>
                                                            <select name="type"
                                                                class="form-select bg-dark text-white border-secondary"
                                                                required>
                                                                <option value="quantity" {{ $unit->type == 'quantity' ? 'selected' : '' }}>{{ __('Quantity') }}</option>
                                                                <option value="time" {{ $unit->type == 'time' ? 'selected' : '' }}>{{ __('Time') }}</option>
                                                            </select>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">{{ __('Base Unit') }}</label>
                                                            <select name="parent_id"
                                                                class="form-select bg-dark text-white border-secondary">
                                                                <option value="">{{ __('None (Base Unit)') }}</option>
                                                                @foreach($units->where('id', '!=', $unit->id) as $parent)
                                                                    <option value="{{ $parent->id }}" {{ $unit->parent_id == $parent->id ? 'selected' : '' }}>
                                                                        {{ $parent->name }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">{{ __('Conversion Factor') }}</label>
                                                            <input type="number" step="0.0001" name="conversion_factor"
                                                                class="form-control bg-dark text-white border-secondary"
                                                                value="{{ $unit->conversion_factor }}">
                                                            <small
                                                                class="text-muted">{{ __('e.g., 1 Box = 12 Pieces → Factor = 12') }}</small>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer border-secondary">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                                        <button type="submit"
                                                            class="btn btn-primary">{{ __('Update') }}</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">
                                            {{ __('No quantity units defined.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Time Units -->
        <div class="col-lg-6">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary">
                    <h5 class="mb-0"><i class="fas fa-clock me-2"></i>{{ __('Time Units') }}</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover mb-0 align-middle">
                            <thead>
                                <tr>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Short') }}</th>
                                    <th>{{ __('Base Unit') }}</th>
                                    <th>{{ __('Factor') }}</th>
                                    <th class="text-end">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($units->where('type', 'time') as $unit)
                                    <tr>
                                        <td class="fw-bold">{{ $unit->name }}</td>
                                        <td><span class="badge bg-info">{{ $unit->short_name ?? '-' }}</span></td>
                                        <td>{{ $unit->parent ? $unit->parent->name : '-' }}</td>
                                        <td>{{ $unit->conversion_factor ?? '-' }}</td>
                                        <td class="text-end">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                                                data-bs-target="#editUnitModal{{ $unit->id }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="{{ route('units.destroy', $unit) }}" method="POST" class="d-inline"
                                                onsubmit="return confirm('{{ __('Are you sure?') }}')">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-4 text-muted">
                                            {{ __('No time units defined.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Unit Modal -->
    <div class="modal fade" id="createUnitModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <form action="{{ route('units.store') }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><i class="fas fa-plus me-2"></i>{{ __('Add New Unit') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Name') }} <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control bg-dark text-white border-secondary" required
                                placeholder="{{ __('e.g., Piece, Kilogram, Hour') }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Short Name') }}</label>
                            <input type="text" name="short_name" class="form-control bg-dark text-white border-secondary"
                                placeholder="{{ __('e.g., pcs, kg, hr') }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Type') }} <span class="text-danger">*</span></label>
                            <select name="type" class="form-select bg-dark text-white border-secondary" required>
                                <option value="quantity">{{ __('Quantity') }}</option>
                                <option value="time">{{ __('Time') }}</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Base Unit') }}</label>
                            <select name="parent_id" class="form-select bg-dark text-white border-secondary">
                                <option value="">{{ __('None (Base Unit)') }}</option>
                                @foreach($units as $parent)
                                    <option value="{{ $parent->id }}">{{ $parent->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Conversion Factor') }}</label>
                            <input type="number" step="0.0001" name="conversion_factor"
                                class="form-control bg-dark text-white border-secondary" placeholder="1">
                            <small class="text-muted">{{ __('How many base units equal 1 of this unit') }}</small>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Create Unit') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection