@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="page-title">{{ __('Warehouses') }}</h1>
            <p class="page-subtitle">{{ __('Manage your inventory locations and storage.') }}</p>
        </div>
        <a href="{{ route('accounting.warehouses.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>{{ __('Add Warehouse') }}
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            @if($warehouses->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Manager') }}</th>
                                <th>{{ __('Contact') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th class="text-end">{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($warehouses as $warehouse)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $warehouse->name }}</div>
                                        @if($warehouse->is_default)
                                            <span class="badge bg-info text-dark">{{ __('Default') }}</span>
                                        @endif
                                        <div class="small text-muted">{{ Str::limit($warehouse->address, 50) }}</div>
                                    </td>
                                    <td>{{ $warehouse->manager_name ?? '-' }}</td>
                                    <td>
                                        @if($warehouse->phone)
                                            <div><i class="fas fa-phone small me-1"></i>{{ $warehouse->phone }}</div>
                                        @endif
                                        @if($warehouse->email)
                                            <div><i class="fas fa-envelope small me-1"></i>{{ $warehouse->email }}</div>
                                        @endif
                                    </td>
                                    <td>
                                        @if($warehouse->is_active)
                                            <span class="badge bg-success">{{ __('Active') }}</span>
                                        @else
                                            <span class="badge bg-secondary">{{ __('Inactive') }}</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group">
                                            <a href="{{ route('accounting.warehouses.edit', $warehouse->id) }}"
                                                class="btn btn-sm btn-outline-secondary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('accounting.warehouses.destroy', $warehouse->id) }}"
                                                method="POST" class="d-inline"
                                                onsubmit="return confirm('{{ __('Are you sure?') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $warehouses->links() }}
                </div>
            @else
                <div class="text-center py-5 text-muted">
                    <i class="fas fa-warehouse fa-3x mb-3 opacity-50"></i>
                    <p>{{ __('No warehouses found.') }}</p>
                </div>
            @endif
        </div>
    </div>
@endsection