@extends('layouts.app')

@section('content')
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('WHMCS Unified Sync') }}</h1>
            <p class="page-subtitle">{{ __('Centralized Data Synchronization with WHMCS Billing') }}</p>
        </div>
        <div>
            <span class="badge {{ $isConfigured ? 'bg-success' : 'bg-danger' }} px-3 py-2">
                <i class="fas fa-{{ $isConfigured ? 'check-circle' : 'exclamation-triangle' }} me-2"></i>
                {{ $isConfigured ? __('WHMCS Configured') : __('WHMCS Not Configured') }}
            </span>
        </div>
    </div>

    @if(!$isConfigured)
        <div class="alert alert-warning border-0 shadow-sm">
            <div class="d-flex align-items-center">
                <i class="fas fa-cog fa-2x me-3"></i>
                <div>
                    <h5 class="alert-heading mb-1">{{ __('Configuration Required') }}</h5>
                    <p class="mb-0">
                        {{ __('Please configure WHMCS API credentials in General Settings before performing any sync operations.') }}
                    </p>
                    <a href="{{ route('settings.index') }}" class="btn btn-sm btn-warning mt-2">{{ __('Go to Settings') }}</a>
                </div>
            </div>
        </div>
    @endif

    <div class="row g-4 mb-4">
        <!-- Status Card -->
        <div class="col-md-12">
            <div class="card glass-card">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted fw-bold text-uppercase small mb-2">{{ __('Last Successful Sync') }}</h6>
                        <h4 class="mb-0 text-white">{{ $lastSync }}</h4>
                    </div>
                    <div class="text-end">
                        <i class="fas fa-sync fa-2x text-primary opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Sync Clients -->
        <div class="col-md-4">
            <div class="card glass-card h-100">
                <div class="card-body text-center py-5">
                    <div class="icon-circle bg-info-subtle text-info mx-auto mb-4"
                        style="width: 80px; height: 80px; line-height: 80px; font-size: 2rem; border-radius: 50%;">
                        <i class="fas fa-users-cog"></i>
                    </div>
                    <h5>{{ __('Sync Clients') }}</h5>
                    <p class="text-muted small mb-4">
                        {{ __('Import all clients from WHMCS into the ERP global customer database.') }}</p>
                    <form action="{{ route('accounting.whmcs.sync-clients') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-info w-100" {{ !$isConfigured ? 'disabled' : '' }}>
                            <i class="fas fa-download me-2"></i>{{ __('Start Client Sync') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sync Invoices -->
        <div class="col-md-4">
            <div class="card glass-card h-100">
                <div class="card-body text-center py-5">
                    <div class="icon-circle bg-primary-subtle text-primary mx-auto mb-4"
                        style="width: 80px; height: 80px; line-height: 80px; font-size: 2rem; border-radius: 50%;">
                        <i class="fas fa-file-invoice-dollar"></i>
                    </div>
                    <h5>{{ __('Sync Invoices') }}</h5>
                    <p class="text-muted small mb-4">
                        {{ __('Import invoices and record automated ledger entries for outstanding payments.') }}</p>
                    <form action="{{ route('accounting.whmcs.sync-invoices') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-primary w-100" {{ !$isConfigured ? 'disabled' : '' }}>
                            <i class="fas fa-download me-2"></i>{{ __('Start Invoice Sync') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sync Licenses -->
        <div class="col-md-4">
            <div class="card glass-card h-100">
                <div class="card-body text-center py-5">
                    <div class="icon-circle bg-warning-subtle text-warning mx-auto mb-4"
                        style="width: 80px; height: 80px; line-height: 80px; font-size: 2rem; border-radius: 50%;">
                        <i class="fas fa-key"></i>
                    </div>
                    <h5>{{ __('Sync Licenses') }}</h5>
                    <p class="text-muted small mb-4">
                        {{ __('Extract software keys and subscription periods from WHMCS products.') }}</p>
                    <form action="{{ route('accounting.whmcs.sync-licenses') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-warning w-100" {{ !$isConfigured ? 'disabled' : '' }}>
                            <i class="fas fa-download me-2"></i>{{ __('Start License Sync') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sync Subscriptions -->
        <div class="col-md-4">
            <div class="card glass-card h-100">
                <div class="card-body text-center py-5">
                    <div class="icon-circle bg-success-subtle text-success mx-auto mb-4"
                        style="width: 80px; height: 80px; line-height: 80px; font-size: 2rem; border-radius: 50%;">
                        <i class="fas fa-calendar-check"></i>
                    </div>
                    <h5>{{ __('Sync Subscriptions') }}</h5>
                    <p class="text-muted small mb-4">
                        {{ __('Import recurring services with billing cycles and due dates.') }}</p>
                    <form action="{{ route('accounting.whmcs.sync-subscriptions') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-success w-100" {{ !$isConfigured ? 'disabled' : '' }}>
                            <i class="fas fa-download me-2"></i>{{ __('Start Subscription Sync') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-5 text-center">
        <div class="p-4 rounded-4 bg-black bg-opacity-25 border border-secondary border-opacity-25">
            <h5 class="text-white">{{ __('Background Sync (Coming Soon)') }}</h5>
            <p class="text-muted mb-0">
                {{ __('Enable cron-based automated daily synchronization to keep your ledger always in sync.') }}</p>
        </div>
    </div>
@endsection