@extends('layouts.app', ['bodyClass' => 'bg-main'])

@section('content')
    <style>
        :root {
            --main-bg: #0f1318;
            --accent-cyan: #00d4ff;
            --accent-purple: #8b5cf6;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
        }

        body {
            font-family:
                {{ app()->getLocale() == 'ar' ? "'Tajawal', sans-serif" : "'Inter', sans-serif" }}
            ;
            background: var(--main-bg);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 20% 80%, rgba(139, 92, 246, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(0, 212, 255, 0.1) 0%, transparent 50%);
            z-index: -1;
        }

        .login-card {
            background: rgba(20, 25, 32, 0.6);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            width: 100%;
            max-width: 420px;
            padding: 40px;
            border-radius: 24px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        .brand-logo {
            font-size: 2.2rem;
            font-weight: 800;
            background: linear-gradient(135deg, var(--accent-cyan), var(--accent-purple));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: -1px;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid var(--glass-border);
            color: #fff;
            border-radius: 12px;
            padding: 12px 16px;
            letter-spacing: 2px;
            text-align: center;
            font-weight: bold;
            font-size: 1.2rem;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.08);
            border-color: var(--accent-cyan);
            box-shadow: 0 0 0 4px rgba(0, 212, 255, 0.1);
            color: #fff;
        }

        .btn-premium {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 14px;
            border-radius: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s;
        }

        .btn-premium:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(118, 75, 162, 0.3);
        }
    </style>

    <div class="login-card">
        <div class="text-center mb-5">
            <h1 class="brand-logo mb-1">SMARTONE</h1>
            <p class="text-muted small">{{ __('Verification Required') }}</p>
        </div>

        <form method="POST" action="{{ route('login.otp.verify') }}">
            @csrf

            <div class="mb-4 text-center">
                <p class="text-white small mb-3">
                    {{ __('A verification code has been sent to your WhatsApp number. Please enter it below.') }}</p>

                <label class="form-label text-muted small fw-bold">{{ __('Verification Code') }}</label>
                <input type="text" class="form-control @error('otp') is-invalid @enderror" name="otp" required autofocus
                    maxlength="6" placeholder="000000">

                @error('otp')
                    <div class="text-danger small mt-2">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-premium btn-primary w-100">
                {{ __('Verify & Login') }} <i class="fas fa-check-circle ms-2 mt-1"></i>
            </button>

            <div class="text-center mt-4">
                <a href="{{ route('login') }}" class="text-muted small text-decoration-none">
                    <i class="fas fa-arrow-left me-1"></i> {{ __('Back to Login') }}
                </a>
            </div>
        </form>
    </div>
@endsection