@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('New Customer') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('customers.index') }}">{{ __('Customers') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Create') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">{{ __('Customer Information') }}</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('customers.store') }}" method="POST">
                @csrf

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="name" class="form-label">{{ __('Full Name') }} <span
                                class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name"
                            value="{{ old('name') }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label for="company" class="form-label">{{ __('Company Name') }}</label>
                        <input type="text" class="form-control @error('company') is-invalid @enderror" id="company"
                            name="company" value="{{ old('company') }}">
                        @error('company')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="email" class="form-label">{{ __('Email Address') }}</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email"
                            name="email" value="{{ old('email') }}">
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label for="phone" class="form-label">{{ __('Phone Number') }}</label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone"
                            value="{{ old('phone') }}">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label for="whatsapp" class="form-label">{{ __('WhatsApp Number') }} <span
                                class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('whatsapp') is-invalid @enderror" id="whatsapp"
                            name="whatsapp" value="{{ old('whatsapp') }}" required>
                        @error('whatsapp')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-12">
                        <label for="address" class="form-label">{{ __('Address') }}</label>
                        <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address"
                            rows="2">{{ old('address') }}</textarea>
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <label for="city" class="form-label">{{ __('City') }}</label>
                        <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city"
                            value="{{ old('city') }}">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label for="country" class="form-label">{{ __('Country') }}</label>
                        <input type="text" class="form-control @error('country') is-invalid @enderror" id="country"
                            name="country" value="{{ old('country') }}">
                        @error('country')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label for="commercial_register" class="form-label">{{ __('Commercial Register') }}</label>
                        <input type="text" class="form-control @error('commercial_register') is-invalid @enderror"
                            id="commercial_register" name="commercial_register" value="{{ old('commercial_register') }}">
                        @error('commercial_register')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label for="tax_id" class="form-label">{{ __('Tax ID') }}</label>
                        <input type="text" class="form-control @error('tax_id') is-invalid @enderror" id="tax_id"
                            name="tax_id" value="{{ old('tax_id') }}">
                        @error('tax_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="customer_type" class="form-label">{{ __('Customer Type') }} <span
                                class="text-danger">*</span></label>
                        <select class="form-select @error('customer_type') is-invalid @enderror" id="customer_type"
                            name="customer_type" required>
                            <option value="individual" {{ old('customer_type') == 'individual' ? 'selected' : '' }}>
                                {{ __('Individual') }}
                            </option>
                            <option value="company" {{ old('customer_type') == 'company' ? 'selected' : '' }}>
                                {{ __('Company') }}
                            </option>
                        </select>
                        @error('customer_type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label for="status" class="form-label">{{ __('Status') }} <span class="text-danger">*</span></label>
                        <select class="form-select @error('status') is-invalid @enderror" id="status" name="status"
                            required>
                            <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>{{ __('Active') }}
                            </option>
                            <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>{{ __('Inactive') }}
                            </option>
                            <option value="suspended" {{ old('status') == 'suspended' ? 'selected' : '' }}>
                                {{ __('Suspended') }}
                            </option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label for="opening_balance" class="form-label">{{ __('Opening Balance') }}</label>
                        <input type="number" step="0.01" class="form-control @error('opening_balance') is-invalid @enderror"
                            id="opening_balance" name="opening_balance" value="{{ old('opening_balance', 0) }}">
                        <div class="form-text small text-muted">
                            {{ __('Negative for debts, Positive for credit.') }}
                        </div>
                        @error('opening_balance')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="customer_group_id" class="form-label">{{ __('Customer Group') }}</label>
                        <select class="form-select @error('customer_group_id') is-invalid @enderror" id="customer_group_id"
                            name="customer_group_id">
                            <option value="">{{ __('None') }}</option>
                            @foreach($groups as $group)
                                <option value="{{ $group->id }}" {{ old('customer_group_id') == $group->id ? 'selected' : '' }}>
                                    {{ $group->name }} ({{ number_format($group->discount_percentage, 0) }}% Off)
                                </option>
                            @endforeach
                        </select>
                        @error('customer_group_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label d-block">{{ __('Loyalty Program') }}</label>
                        <div class="form-check form-switch mt-2">
                            <input class="form-check-input" type="checkbox" id="loyalty_enabled" name="loyalty_enabled"
                                value="1" {{ old('loyalty_enabled') ? 'checked' : '' }}>
                            <label class="form-check-label"
                                for="loyalty_enabled">{{ __('Enable Loyalty Points for this customer') }}</label>
                        </div>
                    </div>
                </div>

                <div class="row mb-4">
                    <div class="col-12">
                        <label for="notes" class="form-label">{{ __('Internal Notes') }}</label>
                        <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes"
                            rows="3">{{ old('notes') }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('customers.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
                    <button type="submit" class="btn btn-primary">{{ __('Create Customer') }}</button>
                </div>
            </form>
        </div>
    </div>
@endsection