@extends('layouts.app')

@section('content')
    <div class="row mb-4 align-items-center">
        <div class="col-12 col-lg-4 mb-2 mb-lg-0">
            <h2 class="fw-light mb-0">{{ __('Customers') }}</h2>
            <p class="text-muted small mb-0 d-none d-lg-block">{{ __('Manage client relationships and sync with WHMCS') }}
            </p>
        </div>
        <div class="col-12 col-lg-8 text-lg-end">
            <div class="d-flex flex-wrap gap-2 justify-content-start justify-content-lg-end">
                <a href="{{ route('customers.create') }}" class="btn btn-primary shadow-sm">
                    <i class="fas fa-plus-circle me-1"></i><span
                        class="d-none d-sm-inline">{{ __('New Customer') }}</span><span
                        class="d-sm-none">{{ __('New') }}</span>
                </a>
                <form action="{{ route('customers.sync-whmcs') }}" method="POST" class="d-inline-block">
                    @csrf
                    <button type="submit" class="btn btn-outline-info">
                        <i class="fas fa-sync me-1"></i><span class="d-none d-md-inline">{{ __('Sync WHMCS') }}</span>
                    </button>
                </form>
                <a href="{{ route('customers.export') }}" class="btn btn-outline-success">
                    <i class="fas fa-file-export me-1"></i><span class="d-none d-md-inline">{{ __('Export') }}</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-users text-primary fa-lg"></i>
                        </div>
                        <span class="text-muted small">{{ __('Total') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['total'] }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-primary" style="width: 100%"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-user-check text-success fa-lg"></i>
                        </div>
                        <span class="text-muted small text-success">{{ __('Active') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['active'] }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success"
                            style="width: {{ $stats['total'] > 0 ? ($stats['active'] / $stats['total']) * 100 : 0 }}%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-warning bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-user-clock text-warning fa-lg"></i>
                        </div>
                        <span class="text-muted small text-warning">{{ __('Inactive') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['inactive'] }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-warning"
                            style="width: {{ $stats['total'] > 0 ? ($stats['inactive'] / $stats['total']) * 100 : 0 }}%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-danger bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-user-slash text-danger fa-lg"></i>
                        </div>
                        <span class="text-muted small text-danger">{{ __('Suspended') }}</span>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['suspended'] }}</h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-danger"
                            style="width: {{ $stats['total'] > 0 ? ($stats['suspended'] / $stats['total']) * 100 : 0 }}%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form action="{{ route('customers.index') }}" method="GET" class="row g-2">
                <div class="col-12 col-md-4 col-lg-3">
                    <div class="input-group">
                        <span class="input-group-text bg-dark border-secondary text-light"><i
                                class="fas fa-search"></i></span>
                        <input type="text" class="form-control" name="search" placeholder="{{ __('Search...') }}"
                            value="{{ request('search') }}">
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <select name="status" class="form-select">
                        <option value="">{{ __('Status') }}</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>{{ __('Active') }}
                        </option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>{{ __('Inactive') }}
                        </option>
                        <option value="suspended" {{ request('status') == 'suspended' ? 'selected' : '' }}>
                            {{ __('Suspended') }}
                        </option>
                    </select>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <select name="source" class="form-select">
                        <option value="">{{ __('Source') }}</option>
                        <option value="manual" {{ request('source') == 'manual' ? 'selected' : '' }}>{{ __('Manual') }}
                        </option>
                        <option value="whmcs" {{ request('source') == 'whmcs' ? 'selected' : '' }}>{{ __('WHMCS') }}</option>
                    </select>
                </div>
                <div class="col-6 col-md-6 col-lg-2">
                    <select name="sort_by" class="form-select">
                        <option value="created_at" {{ request('sort_by') == 'created_at' ? 'selected' : '' }}>{{ __('Date') }}
                        </option>
                        <option value="name" {{ request('sort_by') == 'name' ? 'selected' : '' }}>{{ __('Name') }}</option>
                        <option value="customer_number" {{ request('sort_by') == 'customer_number' ? 'selected' : '' }}>
                            {{ __('ID') }}
                        </option>
                    </select>
                </div>
                <div class="col-6 col-md-6 col-lg-2">
                    <select name="sort_order" class="form-select">
                        <option value="desc" {{ request('sort_order') == 'desc' ? 'selected' : '' }}>{{ __('Desc') }}</option>
                        <option value="asc" {{ request('sort_order') == 'asc' ? 'selected' : '' }}>{{ __('Asc') }}</option>
                    </select>
                </div>
                <div class="col-12 col-lg-1">
                    <button type="submit" class="btn btn-secondary w-100"><i class="fas fa-filter"></i></button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-striped mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th scope="col">
                                <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'customer_number', 'sort_order' => request('sort_by') == 'customer_number' && request('sort_order') == 'asc' ? 'desc' : 'asc']) }}"
                                    class="text-white text-decoration-none d-flex align-items-center gap-1">
                                    {{ __('ID') }}
                                    @if(request('sort_by') == 'customer_number')
                                        <i class="fas fa-sort-{{ request('sort_order') == 'asc' ? 'up' : 'down' }} small"></i>
                                    @else
                                        <i class="fas fa-sort text-muted small opacity-50"></i>
                                    @endif
                                </a>
                            </th>
                            <th scope="col">
                                <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'name', 'sort_order' => request('sort_by') == 'name' && request('sort_order') == 'asc' ? 'desc' : 'asc']) }}"
                                    class="text-white text-decoration-none d-flex align-items-center gap-1">
                                    {{ __('Name') }}
                                    @if(request('sort_by') == 'name')
                                        <i class="fas fa-sort-{{ request('sort_order') == 'asc' ? 'up' : 'down' }} small"></i>
                                    @else
                                        <i class="fas fa-sort text-muted small opacity-50"></i>
                                    @endif
                                </a>
                            </th>
                            <th class="d-none d-lg-table-cell">{{ __('Contact') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Balance') }}</th>
                            <th class="d-none d-xl-table-cell">{{ __('Source') }}</th>
                            <th class="d-none d-xl-table-cell" scope="col">
                                <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'created_at', 'sort_order' => request('sort_by') == 'created_at' && request('sort_order') == 'asc' ? 'desc' : 'asc']) }}"
                                    class="text-white text-decoration-none d-flex align-items-center gap-1">
                                    {{ __('Created') }}
                                    @if(request('sort_by') == 'created_at')
                                        <i class="fas fa-sort-{{ request('sort_order') == 'asc' ? 'up' : 'down' }} small"></i>
                                    @else
                                        <i class="fas fa-sort text-muted small opacity-50"></i>
                                    @endif
                                </a>
                            </th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($customers as $customer)
                            <tr>
                                <td data-label="{{ __('ID') }}">
                                    @if($customer->whmcs_id)
                                        <span class="text-info">#{{ $customer->customer_number }}</span>
                                    @else
                                        #{{ $customer->customer_number }}
                                    @endif
                                </td>
                                <td data-label="{{ __('Name') }}">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar me-2 bg-secondary rounded-circle d-flex align-items-center justify-content-center"
                                            style="width: 35px; height: 35px">
                                            {{ substr($customer->name, 0, 1) }}
                                        </div>
                                        <div>
                                            <div class="fw-bold">{{ $customer->name }}</div>
                                            @if($customer->company)
                                                <div class="small text-muted">{{ $customer->company }}</div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td data-label="{{ __('Contact') }}" class="d-none d-lg-table-cell">
                                    <div><i class="fas fa-envelope me-1 text-muted"></i> {{ $customer->email }}</div>
                                    @if($customer->phone)
                                        <div><i class="fas fa-phone me-1 text-muted"></i> {{ $customer->phone }}</div>
                                    @endif
                                </td>
                                <td data-label="{{ __('Status') }}">
                                    <span class="badge bg-{{ $customer->status_color }}">{{ __($customer->status) }}</span>
                                </td>
                                <td data-label="{{ __('Balance') }}">
                                    <div class="mb-1">
                                        <small class="text-muted d-block">{{ __('Debt') }}:</small>
                                        <span class="fw-bold text-danger">{{ number_format($customer->total_debt, 2) }}</span>
                                    </div>
                                    <div>
                                        <small class="text-muted d-block">{{ __('Wallet') }}:</small>
                                        <span
                                            class="fw-bold text-success">{{ number_format($customer->wallet_balance, 2) }}</span>
                                    </div>
                                </td>
                                <td data-label="{{ __('Source') }}" class="d-none d-xl-table-cell">
                                    @if($customer->source == 'whmcs')
                                        <span class="badge bg-info text-dark">{{ __('WHMCS') }}</span>
                                    @else
                                        <span class="badge bg-secondary">{{ __('Manual') }}</span>
                                    @endif
                                </td>
                                <td data-label="{{ __('Created') }}" class="d-none d-xl-table-cell">
                                    {{ $customer->created_at->format('Y-m-d') }}
                                </td>
                                <td data-label="{{ __('Actions') }}" class="text-end">
                                    <div class="btn-group">
                                        <a href="{{ route('customers.show', $customer) }}" class="btn btn-sm btn-outline-light"
                                            title="{{ __('View') }}"><i class="fas fa-eye"></i></a>
                                        <a href="{{ route('customers.edit', $customer) }}" class="btn btn-sm btn-outline-light"
                                            title="{{ __('Edit') }}"><i class="fas fa-edit"></i></a>
                                        @can('delete customers')
                                            <form action="{{ route('customers.destroy', $customer) }}" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('{{ __('Are you sure you want to delete this customer?') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger"
                                                    title="{{ __('Delete') }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </div>
                                </td>

                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="text-muted mb-3"><i class="fas fa-users-slash fa-3x"></i></div>
                                    <h5>{{ __('No customers found') }}</h5>
                                    <p class="text-muted">{{ __('Try adjusting your filters or create a new customer.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($customers->hasPages())
            <div class="card-footer">
                {{ $customers->links() }}
            </div>
        @endif
    </div>
@endsection