@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light">ملف العميل</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">لوحة التحكم</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('customers.index') }}">العملاء</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $customer->name }}</li>
                </ol>
            </nav>
        </div>
        <div class="col-12 col-md-6 text-md-end d-flex justify-content-md-end gap-2 flex-wrap">
            <a href="{{ route('accounting.invoices.create', ['customer_id' => $customer->id]) }}"
                class="btn btn-outline-warning">
                <i class="fas fa-file-invoice-dollar me-2"></i>فاتورة جديدة
            </a>
            <button class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#createTicketModal">
                <i class="fas fa-plus me-2"></i>إنشاء تذكرة
            </button>
            <a href="{{ route('customers.edit', $customer) }}" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>تعديل
            </a>
            <form action="{{ route('customers.destroy', $customer) }}" method="POST" class="d-inline-block"
                onsubmit="return confirm('هل أنت متأكد من حذف هذا العميل؟');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger">
                    <i class="fas fa-trash me-2"></i>حذف
                </button>
            </form>
        </div>
    </div>

    <div class="row">
        <!-- Mobile Customer Info Card (visible only on mobile) -->
        <div class="col-12 d-md-none mb-3">
            <div class="card glass-card">
                <div class="card-body">
                    <div class="d-flex align-items-center gap-3 mb-3">
                        @if($customer->avatar)
                            <img src="{{ asset('storage/' . $customer->avatar) }}" class="rounded-circle shadow"
                                style="width: 60px; height: 60px; object-fit: cover;">
                        @else
                            <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center shadow"
                                style="width: 60px; height: 60px; font-size: 1.5rem;">
                                {{ substr($customer->name, 0, 1) }}
                            </div>
                        @endif
                        <div class="flex-grow-1">
                            <h5 class="mb-0 text-white">{{ $customer->name }}</h5>
                            <small class="text-muted">{{ $customer->company ?: 'فرد' }}</small>
                            <div class="mt-1">
                                <span class="badge bg-{{ $customer->status_color }}">{{ ucfirst($customer->status) }}</span>
                                @if($customer->customerGroup)
                                    <span class="badge bg-primary">{{ $customer->customerGroup->name }}</span>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Balance & Points Row -->
                    <div class="row g-2 mb-3">
                        <div class="col-4">
                            <div class="bg-dark rounded p-2 text-center border border-secondary">
                                <small class="text-muted d-block">إجمالى المديونية</small>
                                <span class="fw-bold text-danger">
                                    {{ number_format($customer->total_debt, 2) }} ج.م
                                </span>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="bg-dark rounded p-2 text-center border border-secondary">
                                <div class="d-flex justify-content-center align-items-center gap-1">
                                    <small class="text-muted">الرصيد المتاح</small>
                                    <button class="btn btn-outline-primary btn-sm py-0 px-1" data-bs-toggle="modal"
                                        data-bs-target="#walletModal">
                                        <i class="fas fa-plus-minus" style="font-size: 0.6rem;"></i>
                                    </button>
                                </div>
                                <span class="fw-bold text-success">
                                    {{ number_format($customer->wallet_balance, 2) }} ج.م
                                </span>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="bg-dark rounded p-2 text-center border border-secondary">
                                <small class="text-muted d-block">النقاط</small>
                                <span class="text-warning fw-bold">{{ number_format($customer->loyalty_points, 0) }} <i
                                        class="fas fa-star"></i></span>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="d-flex flex-wrap gap-2 justify-content-center">
                        @if($customer->whatsapp || $customer->phone)
                            <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#whatsappModal">
                                <i class="fab fa-whatsapp"></i>
                            </button>
                        @endif
                        <a href="mailto:{{ $customer->email }}" class="btn btn-outline-info btn-sm">
                            <i class="fas fa-envelope"></i>
                        </a>
                        <a href="{{ route('accounting.invoices.create', ['customer_id' => $customer->id]) }}"
                            class="btn btn-outline-warning btn-sm">
                            <i class="fas fa-file-invoice-dollar"></i>
                        </a>
                        <a href="{{ route('customers.edit', $customer) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar Info (hidden on mobile) -->
        <div class="col-md-3 mb-4 d-none d-md-block">
            <div class="card glass-card sticky-top" style="top: 20px;">
                <div class="card-body text-center">
                    <div class="mb-3 position-relative d-inline-block">
                        @if($customer->avatar)
                            <img src="{{ asset('storage/' . $customer->avatar) }}" class="rounded-circle img-thumbnail shadow"
                                style="width: 120px; height: 120px; object-fit: cover;">
                        @else
                            <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center mx-auto shadow"
                                style="width: 100px; height: 100px; font-size: 2.5rem;">
                                {{ substr($customer->name, 0, 1) }}
                            </div>
                        @endif
                        <a href="{{ route('customers.edit', $customer) }}"
                            class="btn btn-sm btn-dark position-absolute bottom-0 end-0 rounded-circle p-1 shadow-sm"
                            title="تعديل الصورة">
                            <i class="fas fa-camera p-1"></i>
                        </a>
                    </div>
                    <h5 class="mb-1 text-white">{{ $customer->name }}</h5>
                    <p class="text-muted small mb-3">{{ $customer->company ?: 'فرد' }}</p>

                    <div class="mb-3 d-flex flex-wrap justify-content-center gap-1">
                        <span class="badge bg-{{ $customer->status_color }}">{{ ucfirst($customer->status) }}</span>
                        @if($customer->customerGroup)
                            <span class="badge bg-primary">{{ $customer->customerGroup->name }}</span>
                        @endif
                    </div>

                    <div class="bg-dark rounded p-3 mb-3 border border-secondary shadow-sm text-start">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <span class="text-muted small">إجمالى المديونية</span>
                                <span class="badge bg-danger-soft text-danger">مستحق</span>
                            </div>
                            <span class="fw-bold fs-5 text-danger d-block">
                                {{ number_format($customer->total_debt, 2) }} ج.م
                            </span>
                        </div>

                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <span class="text-muted small">الرصيد المتاح</span>
                                <button class="btn btn-outline-primary btn-sm py-0 px-2" data-bs-toggle="modal"
                                    data-bs-target="#walletModal" title="إضافة / تعديل الرصيد">
                                    <i class="fas fa-plus-minus"></i>
                                </button>
                            </div>
                            <span class="fw-bold fs-5 text-success d-block">
                                {{ number_format($customer->wallet_balance, 2) }} ج.م
                            </span>
                        </div>

                        <hr class="my-2 border-secondary opacity-25">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-muted small">صافي الحساب</span>
                            <span
                                class="fw-bold {{ $customer->base_currency_balance >= 0 ? 'text-danger' : 'text-success' }}">
                                {{ number_format(abs($customer->base_currency_balance), 2) }} ج.م
                                <small class="d-block text-muted"
                                    style="font-size: 0.7rem;">({{ $customer->base_currency_balance >= 0 ? 'مستحق على العميل' : 'رصيد دائن للعميل' }})</small>
                            </span>
                        </div>
                        <hr class="my-2 border-secondary opacity-25">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="text-muted small">النقاط</span>
                            <span class="text-warning fw-bold">{{ number_format($customer->loyalty_points, 0) }} <i
                                    class="fas fa-star ms-1"></i></span>
                        </div>
                    </div>

                    <div class="d-grid gap-2">
                        @if($customer->whatsapp || $customer->phone)
                            <button class="btn btn-success btn-sm w-100" data-bs-toggle="modal" data-bs-target="#whatsappModal">
                                <i class="fab fa-whatsapp me-2"></i>واتساب
                            </button>
                        @endif
                        <a href="mailto:{{ $customer->email }}" class="btn btn-outline-info btn-sm w-100">
                            <i class="fas fa-envelope me-2"></i>البريد الإلكتروني
                        </a>

                        <button class="btn btn-outline-primary btn-sm w-100" onclick="copyLoginLink()">
                            <i class="fas fa-phone me-2"></i>رابط تسجيل الدخول (الهاتف)
                        </button>
                        <hr class="border-secondary opacity-25">
                        <a href="{{ route('accounting.invoices.create', ['customer_id' => $customer->id]) }}"
                            class="btn btn-outline-warning btn-sm w-100">
                            <i class="fas fa-file-invoice-dollar me-2"></i>إنشاء فاتورة
                        </a>
                        <button class="btn btn-outline-light btn-sm w-100" data-bs-toggle="modal"
                            data-bs-target="#createTicketModal">
                            <i class="fas fa-plus me-2"></i>فتح تذكرة دعم
                        </button>

                        <input type="hidden" value="{{ route('portal.login') }}" id="loginLink">
                    </div>
                </div>

                <div class="card-footer bg-transparent border-secondary p-0">
                    <div class="list-group list-group-flush small">
                        <div class="list-group-item bg-transparent text-white border-secondary px-3 py-2">
                            <div class="text-muted mb-1">رقم العميل</div>
                            <div>{{ $customer->customer_number }}</div>
                        </div>
                        <div class="list-group-item bg-transparent text-white border-secondary px-3 py-2">
                            <div class="text-muted mb-1">الهاتف</div>
                            <div>{{ $customer->phone ?: 'غير متوفر' }}</div>
                        </div>
                        <div class="list-group-item bg-transparent text-white border-secondary px-3 py-2">
                            <div class="text-muted mb-1">الرقم الضريبي / السجل</div>
                            <div>{{ $customer->tax_id ?: 'غير متوفر' }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Tabs -->
        <div class="col-md-9 mb-4">
            <div class="card glass-card h-100">
                <div class="card-header p-0 border-bottom-0 bg-transparent">
                    <ul class="nav nav-tabs border-0" id="customerTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="overview-tab" data-bs-toggle="tab" href="#overview"
                                role="tab">نظرة عامة</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="notes-tab" data-bs-toggle="tab" href="#notes" role="tab">ملاحظات</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="tickets-tab" data-bs-toggle="tab" href="#tickets" role="tab">التذاكر</a>
                        </li>
                        @if($customer->isFromWhmcs())
                            <li class="nav-item">
                                <a class="nav-link" id="hosting-tab" data-bs-toggle="tab" href="#hosting"
                                    role="tab">الاستضافة</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="domains-tab" data-bs-toggle="tab" href="#domains"
                                    role="tab">الدومينات</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="whmcs-invoices-tab" data-bs-toggle="tab" href="#whmcs-invoices"
                                    role="tab">فواتير WHMCS</a>
                            </li>
                        @endif
                        <li class="nav-item">
                            <a class="nav-link" id="documents-tab" data-bs-toggle="tab" href="#documents"
                                role="tab">المستندات</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="projects-tab" data-bs-toggle="tab" href="#projects"
                                role="tab">المشاريع</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="local-invoices-tab" data-bs-toggle="tab" href="#local-invoices"
                                role="tab">الفواتير</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="wallet-tab" data-bs-toggle="tab" href="#wallet" role="tab">المحفظة
                                والرصيد</a>
                        </li>
                        @if($customer->loyalty_enabled)
                            <li class="nav-item">
                                <a class="nav-link" id="loyalty-tab" data-bs-toggle="tab" href="#loyalty" role="tab">الولاء</a>
                            </li>
                        @endif
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content pt-3" id="customerTabContent">


                        <!- Overview Tab -->
                            <div class="tab-pane fade show active" id="overview" role="tabpanel">
                                <h6 class="text-uppercase text-muted mb-3">ملاحظات داخلية</h6>
                                <div class="p-3 bg-dark rounded border border-secondary mb-4">
                                    {{ $customer->notes ?? 'لا توجد ملاحظات داخلية.' }}
                                </div>

                                <h6 class="text-uppercase text-muted mb-3">سجل النشاط</h6>
                                <p class="text-muted">تم إنشاء العميل في
                                    {{ $customer->created_at->format('Y-m-d') }}
                                </p>
                            </div>

                            <!-- Notes Tab -->
                            <div class="tab-pane fade" id="notes" role="tabpanel">
                                <form action="{{ route('customers.notes.store', $customer) }}" method="POST" class="mb-4"
                                    id="noteForm">
                                    @csrf
                                    <input type="hidden" name="_method" id="noteMethod" value="POST">
                                    <div class="mb-3">
                                        <label for="note" class="form-label" id="noteLabel">إضافة ملاحظة</label>
                                        <textarea name="note" id="noteText" class="form-control" rows="3"
                                            required></textarea>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_private" value="1"
                                                id="is_private">
                                            <label class="form-check-label" for="is_private">
                                                ملاحظة خاصة
                                            </label>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <button type="button" class="btn btn-secondary btn-sm d-none"
                                                id="cancelNoteEdit" onclick="resetNoteForm()">إلغاء</button>
                                            <button type="submit" class="btn btn-primary btn-sm" id="saveNoteBtn">إضافة
                                                ملاحظة</button>
                                        </div>
                                    </div>
                                </form>


                                <div class="timeline">
                                    @forelse($customer->customerNotes()->latest()->get() as $note)
                                        <div class="card mb-3 bg-dark border-secondary">
                                            <div class="card-body p-3">
                                                <div class="d-flex justify-content-between mb-2">
                                                    <strong>{{ $note->user->name ?? 'النظام' }}</strong>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <small
                                                            class="text-muted">{{ $note->created_at->diffForHumans() }}</small>
                                                        <button class="btn btn-sm btn-outline-warning p-1"
                                                            onclick="editNote({{ $note->id }}, '{{ addslashes($note->note) }}')"
                                                            title="تعديل">
                                                            <i class="fas fa-edit fa-xs"></i>
                                                        </button>
                                                        <form
                                                            action="{{ route('customers.notes.destroy', [$customer, $note]) }}"
                                                            method="POST" class="d-inline"
                                                            onsubmit="return confirm('هل أنت متأكد من حذف هذه الملاحظة؟')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-outline-danger p-1"
                                                                title="حذف">
                                                                <i class="fas fa-trash fa-xs"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                                <p class="mb-0 {{ $note->is_private ? 'text-warning' : '' }}">
                                                    @if($note->is_private) <i class="fas fa-lock me-1"></i>
                                                    @endif
                                                    {{ $note->note }}
                                                </p>
                                            </div>
                                        </div>
                                    @empty
                                        <p class="text-center text-muted">لا توجد ملاحظات مضافة بعد.</p>
                                    @endforelse
                                </div>
                            </div>


                            <!-- Documents Tab -->
                            <div class="tab-pane fade" id="documents" role="tabpanel">
                                <form action="{{ route('customers.documents.store', $customer) }}" method="POST"
                                    enctype="multipart/form-data" class="mb-4">
                                    @csrf
                                    <div class="row g-2">
                                        <div class="col-md-5">
                                            <input type="text" name="title" class="form-control" placeholder="عنوان المستند"
                                                required>
                                        </div>
                                        <div class="col-md-5">
                                            <input type="file" name="file" class="form-control" required>
                                        </div>
                                        <div class="col-md-2">
                                            <button type="submit" class="btn btn-primary w-100">رفع</button>
                                        </div>
                                    </div>
                                </form>

                                <div class="table-responsive">
                                    <table class="table table-hover align-middle">
                                        <thead>
                                            <tr>
                                                <th>العنوان</th>
                                                <th>الحجم</th>
                                                <th>بواسطة</th>
                                                <th>التاريخ</th>
                                                <th>الإجراء</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($customer->documents as $doc)
                                                <tr>
                                                    <td>
                                                        <i class="fas fa-file me-2 text-primary"></i>
                                                        {{ $doc->title }}
                                                    </td>
                                                    <td>{{ $doc->formatted_size }}</td>
                                                    <td>{{ $doc->uploader->name ?? 'Unknown' }}</td>
                                                    <td>{{ $doc->created_at->format('Y-m-d') }}</td>
                                                    <td>
                                                        <a href="{{ Storage::url($doc->file_path) }}" target="_blank"
                                                            class="btn btn-sm btn-outline-light" title="تحميل">
                                                            <i class="fas fa-download"></i>
                                                        </a>
                                                        <form
                                                            action="{{ route('customers.documents.destroy', [$customer, $doc]) }}"
                                                            method="POST" class="d-inline"
                                                            onsubmit="return confirm('هل أنت متأكد من حذف هذا المستند؟')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                                title="حذف">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </td>

                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted">No documents
                                                        uploaded.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- WHMCS Tab -->
                            @if($customer->isFromWhmcs() && isset($whmcsData))
                                <div class="tab-pane fade" id="whmcs" role="tabpanel">
                                    <h6 class="text-uppercase text-muted my-3">Products & Services</h6>
                                    <div class="table-responsive mb-4">
                                        <table class="table table-sm table-dark">
                                            <thead>
                                                <tr>
                                                    <th>Product</th>
                                                    <th>Domain</th>
                                                    <th>Price</th>
                                                    <th>Billing</th>
                                                    <th>Status</th>
                                                    <th>Next Due</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($whmcsData['products']['products']['product']))
                                                    @foreach($whmcsData['products']['products']['product'] as $product)
                                                        <tr>
                                                            <td>{{ $product['name'] }}</td>
                                                            <td>{{ $product['domain'] }}</td>
                                                            <td>{{ $product['recurringamount'] }}</td>
                                                            <td>{{ $product['billingcycle'] }}</td>
                                                            <td><span
                                                                    class="badge bg-{{ $product['status'] == 'Active' ? 'success' : 'warning' }}">{{ $product['status'] }}</span>
                                                            </td>
                                                            <td>{{ $product['nextduedate'] }}</td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <tr>
                                                        <td colspan="6" class="text-center text-muted">No products
                                                            found</td>
                                                    </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>

                                    <h6 class="text-uppercase text-muted my-3">Invoices</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-dark">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Date</th>
                                                    <th>Due Date</th>
                                                    <th>Total</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($whmcsData['invoices']['invoices']['invoice']))
                                                    @foreach($whmcsData['invoices']['invoices']['invoice'] as $invoice)
                                                        <tr>
                                                            <td>{{ $invoice['id'] }}</td>
                                                            <td>{{ $invoice['date'] }}</td>
                                                            <td>{{ $invoice['duedate'] }}</td>
                                                            <td>{{ $invoice['total'] }}</td>
                                                            <td>
                                                                <span
                                                                    class="badge bg-{{ $invoice['status'] == 'Paid' ? 'success' : ($invoice['status'] == 'Unpaid' ? 'danger' : 'secondary') }}">
                                                                    {{ $invoice['status'] }}
                                                                </span>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <tr>
                                                        <td colspan="5" class="text-center text-muted">No invoices
                                                            found</td>
                                                    </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endif

                            <!-- Projects Tab -->
                            <div class="tab-pane fade" id="projects" role="tabpanel">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="text-uppercase text-muted mb-0">مشاريع العميل</h6>
                                    <a href="{{ route('accounting.projects.create', ['customer_id' => $customer->id]) }}"
                                        class="btn btn-sm btn-primary">
                                        <i class="fas fa-plus me-1"></i>مشروع جديد
                                    </a>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover table-dark align-middle">
                                        <thead class="bg-black">
                                            <tr>
                                                <th>اسم المشروع</th>
                                                <th>المبرمج</th>
                                                <th>التقدم</th>
                                                <th>الحالة</th>
                                                <th class="text-end">الإجراء</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($customer->projects as $project)
                                                <tr>
                                                    <td>{{ $project->name }}</td>
                                                    <td>
                                                        <a href="{{ route('accounting.programmers.statement', $project->programmer) }}"
                                                            class="text-info text-decoration-none small">
                                                            {{ $project->programmer->name }}
                                                        </a>
                                                    </td>
                                                    <td style="width: 20%">
                                                        <div class="progress bg-black" style="height: 5px;">
                                                            <div class="progress-bar bg-success"
                                                                style="width: {{ $project->progress_percent }}%">
                                                            </div>
                                                        </div>
                                                        <small class="text-muted">{{ $project->progress_percent }}%</small>
                                                    </td>
                                                    <td>
                                                        @php
                                                            $color = match ($project->status) {
                                                                'completed' => 'success',
                                                                'in_progress' => 'info',
                                                                'on_hold' => 'warning',
                                                                'cancelled' => 'danger',
                                                                default => 'secondary'
                                                            };
                                                        @endphp
                                                        <span
                                                            class="badge bg-{{ $color }}">{{ ucfirst($project->status) }}</span>
                                                    </td>
                                                    <td class="text-end">
                                                        <a href="{{ route('accounting.projects.show', $project) }}"
                                                            class="btn btn-sm btn-outline-light" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                        <a href="{{ route('accounting.projects.edit', $project) }}"
                                                            class="btn btn-sm btn-outline-warning" title="تعديل">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <form action="{{ route('accounting.projects.destroy', $project) }}"
                                                            method="POST" class="d-inline"
                                                            onsubmit="return confirm('هل أنت متأكد من حذف هذا المشروع؟')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                                title="حذف">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </td>

                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted py-5">
                                                        <i class="fas fa-project-diagram fa-3x mb-3 opacity-25"></i>
                                                        <p>No projects linked to this customer yet.</p>
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Local Invoices Tab -->
                            <div class="tab-pane fade" id="local-invoices" role="tabpanel">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="text-uppercase text-muted mb-0">فواتير النظام</h6>
                                    <a href="{{ route('accounting.invoices.create', ['customer_id' => $customer->id]) }}"
                                        class="btn btn-sm btn-primary">
                                        <i class="fas fa-plus me-1"></i>فاتورة جديدة
                                    </a>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover table-dark align-middle">
                                        <thead class="bg-black">
                                            <tr>
                                                <th>رقم الفاتورة</th>
                                                <th>التاريخ</th>
                                                <th>الإجمالي</th>
                                                <th>المدفوع</th>
                                                <th>الحالة</th>
                                                <th class="text-end">الإجراء</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($customer->invoices as $invoice)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('accounting.invoices.show', $invoice) }}"
                                                            class="text-info text-decoration-none">
                                                            {{ $invoice->code }}
                                                        </a>
                                                    </td>
                                                    <td>{{ $invoice->date ? $invoice->date->format('Y-m-d') : '-' }}</td>
                                                    <td>{{ number_format($invoice->total, 2) }} ج.م</td>
                                                    <td>{{ number_format($invoice->paid_amount, 2) }} ج.م</td>
                                                    <td>
                                                        @php
                                                            $status_color = match ($invoice->status) {
                                                                'paid' => 'success',
                                                                'partial' => 'warning',
                                                                'unpaid' => 'danger',
                                                                'cancelled' => 'secondary',
                                                                default => 'info'
                                                            };
                                                        @endphp
                                                        <span class="badge bg-{{ $status_color }}">
                                                            {{ $invoice->status == 'paid' ? 'مدفوعة' : ($invoice->status == 'partial' ? 'مدفوعة جزئياً' : ($invoice->status == 'unpaid' ? 'غير مدفوعة' : $invoice->status)) }}
                                                        </span>
                                                    </td>
                                                    <td class="text-end">
                                                        <a href="{{ route('accounting.invoices.show', $invoice) }}"
                                                            class="btn btn-sm btn-outline-light" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                        @if($invoice->status != 'paid')
                                                            <a href="{{ route('accounting.invoices.edit', $invoice) }}"
                                                                class="btn btn-sm btn-outline-warning" title="تعديل">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                        @endif
                                                        <form action="{{ route('accounting.invoices.destroy', $invoice) }}"
                                                            method="POST" class="d-inline"
                                                            onsubmit="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                                title="حذف">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </td>

                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="6" class="text-center text-muted py-5">
                                                        <i class="fas fa-file-invoice-dollar fa-3x mb-3 opacity-25"></i>
                                                        <p>لا توجد فواتير لهذا العميل حتى الآن.</p>
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Loyalty Tab -->
                            @if($customer->loyalty_enabled)
                                <div class="tab-pane fade" id="loyalty" role="tabpanel">
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <div class="card bg-warning text-dark">
                                                <div class="card-body">
                                                    <h6 class="card-title"><i class="fas fa-coins me-2"></i>رصيد النقاط</h6>
                                                    <h3>{{ number_format($customer->loyalty_points, 0) }} <small
                                                            class="fs-6">نقطة</small></h3>
                                                </div>
                                            </div>
                                            <div class="col-md-6 d-flex align-items-center justify-content-end">
                                                <button class="btn btn-warning text-dark opacity-100" data-bs-toggle="modal"
                                                    data-bs-target="#loyaltyModal">
                                                    <i class="fas fa-plus-circle me-2"></i>إضافة / خصم نقاط
                                                </button>
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-hover table-dark align-middle">
                                                <thead>
                                                    <tr>
                                                        <th>التاريخ</th>
                                                        <th>الوصف</th>
                                                        <th>النوع</th>
                                                        <th>النقاط</th>
                                                        <th>المرجع</th>
                                                        <th class="text-end">الإجراء</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($customer->loyaltyTransactions()->latest()->get() as $transaction)
                                                        <tr>
                                                            <td>{{ $transaction->date->format('Y-m-d') }}</td>
                                                            <td>{{ $transaction->description }}</td>
                                                            <td>
                                                                @if($transaction->type == 'earned')
                                                                    <span class="badge bg-success">تم كسبها</span>
                                                                @elseif($transaction->type == 'redeemed')
                                                                    <span class="badge bg-danger">تم استبدالها</span>
                                                                @else
                                                                    <span class="badge bg-secondary">{{ $transaction->type }}</span>
                                                                @endif
                                                            </td>
                                                            <td
                                                                class="{{ $transaction->points > 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                                                {{ $transaction->points > 0 ? '+' : '' }}{{ number_format($transaction->points, 0) }}
                                                            </td>
                                                            <td>
                                                                @if($transaction->reference_type == 'App\Models\Invoice' && $transaction->reference)
                                                                    <a href="{{ route('accounting.invoices.show', $transaction->reference_id) }}"
                                                                        class="btn btn-sm btn-outline-light">
                                                                        فاتورة #{{ $transaction->reference->code }}
                                                                    </a>
                                                                @else
                                                                    -
                                                                @endif
                                                            </td>
                                                            <td class="text-end">
                                                                <button class="btn btn-sm btn-outline-warning p-0 px-2 ms-2"
                                                                    onclick="editLoyaltyTransaction({{ $transaction->id }}, {{ abs($transaction->points) }}, '{{ $transaction->type }}', '{{ addslashes($transaction->description) }}', '{{ $transaction->date->format('Y-m-d') }}')"
                                                                    title="تعديل">
                                                                    <i class="fas fa-edit fa-xs"></i>
                                                                </button>
                                                                @can('delete customers')
                                                                    <form
                                                                        action="{{ route('customers.loyalty.destroy', [$customer, $transaction]) }}"
                                                                        method="POST" class="d-inline"
                                                                        onsubmit="return confirm('هل أنت متأكد من حذف هذه العملية؟ سيتم عكس النقاط المكتسبة/المستعملة.')">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button type="submit"
                                                                            class="btn btn-sm btn-outline-danger p-0 px-2" title="حذف">
                                                                            <i class="fas fa-trash fa-xs"></i>
                                                                        </button>
                                                                    </form>
                                                                @endcan
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="5" class="text-center text-muted py-4">
                                                                لا توجد حركات ولاء حتى الآن.
                                                            </td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                            @endif

                                <!-- Licenses Tab -->
                                <div class="tab-pane fade" id="licenses" role="tabpanel">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="text-uppercase text-muted mb-0">تراخيص البرمجيات والسيريالات
                                        </h6>
                                        @if($customer->whmcs_id)
                                            <form action="{{ route('accounting.licenses.sync', $customer) }}" method="POST">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-sync-alt me-1"></i>مزامنة من WHMCS
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-hover table-dark align-middle">
                                            <thead class="bg-black">
                                                <tr>
                                                    <th>البرنامج</th>
                                                    <th>مفتاح السيريال</th>
                                                    <th>تاريخ البدء</th>
                                                    <th>تاريخ الانتهاء</th>
                                                    <th>الحالة</th>
                                                    <th class="text-end">الإجراء</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($customer->licenses as $license)
                                                    <tr>
                                                        <td>{{ $license->software_name }}</td>
                                                        <td><code>{{ $license->serial_key }}</code></td>
                                                        <td>{{ $license->start_date ? $license->start_date->format('Y-m-d') : '-' }}
                                                        </td>
                                                        <td>{{ $license->end_date ? $license->end_date->format('Y-m-d') : '-' }}
                                                        </td>
                                                        <td>
                                                            @php
                                                                $l_color = match ($license->status) {
                                                                    'active' => 'success',
                                                                    'expired' => 'danger',
                                                                    'revoked' => 'warning',
                                                                    default => 'secondary'
                                                                };
                                                            @endphp
                                                            <span
                                                                class="badge bg-{{ $l_color }}">{{ ucfirst($license->status) }}</span>
                                                        </td>
                                                        <td class="text-end">
                                                            <button class="btn btn-sm btn-success"
                                                                onclick="sendSerialWhatsapp('{{ $license->serial_key }}', '{{ $license->software_name }}')">
                                                                <i class="fab fa-whatsapp"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="6" class="text-center text-muted py-5">
                                                            <i class="fas fa-key fa-3x mb-3 opacity-25"></i>
                                                            <p>No licenses found for this customer.</p>
                                                        </td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!-- Wallet Tab -->
                                <div class="tab-pane fade" id="wallet" role="tabpanel">
                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <div class="card bg-dark border-secondary">
                                                <div class="card-body">
                                                    <h6 class="text-muted text-uppercase small">الرصيد الحالي
                                                    </h6>
                                                    <h2
                                                        class="{{ $customer->base_currency_balance >= 0 ? 'text-success' : 'text-danger' }} mb-0">
                                                        {{ number_format($customer->base_currency_balance, 2) }} <small
                                                            class="fs-6">ج.م</small>
                                                    </h2>
                                                    <h5 class="text-muted mt-1">
                                                        ~{{ number_format($customer->usd_balance, 2) }} <small
                                                            class="fs-6">USD</small>
                                                    </h5>
                                                    @if($customer->opening_balance != 0)
                                                        <small class="text-muted">الرصيد الافتتاحي:
                                                            {{ number_format($customer->opening_balance, 2) }}</small>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 d-flex align-items-center justify-content-end">
                                            <button class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#walletModal">
                                                <i class="fas fa-plus-circle me-2"></i>إضافة / تعديل الرصيد
                                            </button>
                                        </div>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-hover table-dark align-middle">
                                            <thead>
                                                <tr>
                                                    <th>التاريخ</th>
                                                    <th>النوع</th>
                                                    <th>المبلغ</th>
                                                    <th>الوسيلة</th>
                                                    <th>ملاحظات</th>
                                                    <th>المستخدم</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($customer->walletTransactions()->latest()->get() as $tx)
                                                    <tr>
                                                        <td>{{ $tx->date->format('Y-m-d') }}</td>
                                                        <td>
                                                            @php
                                                                $tx_color = match ($tx->type) {
                                                                    'deposit' => 'success',
                                                                    'withdrawal' => 'danger',
                                                                    'invoice_payment' => 'info',
                                                                    'adjustment' => 'secondary',
                                                                    default => 'light'
                                                                };
                                                            @endphp
                                                            <span
                                                                class="badge bg-{{ $tx_color }}">{{ ucfirst(str_replace('_', ' ', $tx->type)) }}</span>
                                                        </td>
                                                        <td
                                                            class="{{ in_array($tx->type, ['deposit', 'adjustment']) ? 'text-success' : 'text-danger' }} fw-bold">
                                                            {{ in_array($tx->type, ['deposit', 'adjustment']) ? '+' : '-' }}{{ number_format($tx->amount, 2) }}
                                                        </td>
                                                        <td>{{ $tx->payment_method ?? '-' }}</td>
                                                        <td>{{ $tx->notes }}</td>
                                                        </td>
                                                        <td>
                                                            {{ $tx->user->name ?? 'System' }}
                                                            <button class="btn btn-sm btn-outline-warning p-0 px-2 ms-2"
                                                                onclick="editWalletTransaction({{ $tx->id }}, '{{ $tx->type }}', {{ $tx->amount }}, '{{ $tx->payment_method }}', '{{ $tx->date->format('Y-m-d') }}', '{{ addslashes($tx->notes) }}')"
                                                                title="تعديل">
                                                                <i class="fas fa-edit fa-xs"></i>
                                                            </button>
                                                            @can('delete customers')
                                                                <form
                                                                    action="{{ route('customers.wallet.destroy', [$customer, $tx]) }}"
                                                                    method="POST" class="d-inline ms-2"
                                                                    onsubmit="return confirm('هل أنت متأكد من حذف هذه المعاملة؟ سيتم عكس تأثيرها على الرصيد.')">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit"
                                                                        class="btn btn-sm btn-outline-danger p-0 px-2" title="حذف">
                                                                        <i class="fas fa-trash fa-xs"></i>
                                                                    </button>
                                                                </form>
                                                            @endcan
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="6" class="text-center text-muted py-4">No
                                                            wallet transactions found.</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                @if($customer->isFromWhmcs() && isset($whmcsData))
                                    <!-- Hosting Tab -->
                                    <div class="tab-pane fade" id="hosting" role="tabpanel">
                                        <h6 class="text-uppercase text-muted mb-3">خدمات الاستضافة</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm table-dark">
                                                <thead>
                                                    <tr>
                                                        <th>المنتج</th>
                                                        <th>الدومين</th>
                                                        <th>المبلغ الدقيق</th>
                                                        <th>الحالة</th>
                                                        <th>تاريخ الاستحقاق</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($whmcsData['products']['products']['product'] ?? [] as $product)
                                                        <tr>
                                                            <td>{{ $product['name'] }}</td>
                                                            <td>{{ $product['domain'] }}</td>
                                                            <td>{{ $product['recurringamount'] }} {{ $product['billingcycle'] }}
                                                            </td>
                                                            <td><span
                                                                    class="badge bg-{{ $product['status'] == 'Active' ? 'success' : 'warning' }}">{{ $product['status'] }}</span>
                                                            </td>
                                                            <td>{{ $product['nextduedate'] }}</td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="5" class="text-center">لا توجد خدمات استضافة مهارة.
                                                            </td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <!-- Domains Tab -->
                                    <div class="tab-pane fade" id="domains" role="tabpanel">
                                        <h6 class="text-uppercase text-muted mb-3">الدومينات المسجلة</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm table-dark">
                                                <thead>
                                                    <tr>
                                                        <th>الدومين</th>
                                                        <th>تاريخ التسجيل</th>
                                                        <th>الاستحقاق القادم</th>
                                                        <th>المبلغ</th>
                                                        <th>الحالة</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($whmcsData['domains']['domains']['domain'] ?? [] as $domain)
                                                        <tr>
                                                            <td>{{ $domain['domainname'] }}</td>
                                                            <td>{{ $domain['registrationdate'] }}</td>
                                                            <td>{{ $domain['nextduedate'] }}</td>
                                                            <td>{{ $domain['recurringamount'] }}</td>
                                                            <td><span
                                                                    class="badge bg-{{ $domain['status'] == 'Active' ? 'success' : 'warning' }}">{{ $domain['status'] }}</span>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="5" class="text-center">لا توجد دومينات مهارة.</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <!-- Invoices Tab -->
                                    <div class="tab-pane fade" id="whmcs-invoices" role="tabpanel">
                                        <h6 class="text-uppercase text-muted mb-3">فواتير WHMCS</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm table-dark">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>التاريخ</th>
                                                        <th>تاريخ الاستحقاق</th>
                                                        <th>الإجمالي</th>
                                                        <th>الحالة</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($whmcsData['invoices']['invoices']['invoice'] ?? [] as $invoice)
                                                        <tr>
                                                            <td>{{ $invoice['id'] }}</td>
                                                            <td>{{ $invoice['date'] }}</td>
                                                            <td>{{ $invoice['duedate'] }}</td>
                                                            <td>{{ $invoice['total'] }}</td>
                                                            <td><span
                                                                    class="badge bg-{{ $invoice['status'] == 'Paid' ? 'success' : 'danger' }}">{{ $invoice['status'] }}</span>
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="5" class="text-center">لا توجد فواتير مهارة.</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endif

                                <!-- Tickets Tab -->
                                <div class="tab-pane fade" id="tickets" role="tabpanel">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="text-uppercase text-muted mb-0">تذاكر الدعم الفني</h6>
                                        <div class="d-flex gap-2">
                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#createTicketModal">
                                                <i class="fas fa-plus me-1"></i>إنشاء تذكرة دعم
                                            </button>
                                            <form action="{{ route('accounting.tickets.sync', $customer) }}" method="POST">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-sync me-1"></i>مزامنة التذاكر
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-dark">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الموضوع</th>
                                                    <th>القسم</th>
                                                    <th>الحالة</th>
                                                    <th>آخر رد</th>
                                                    <th>الإجراء</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($whmcsData['tickets']['tickets']['ticket'] ?? [] as $ticket)
                                                    <tr>
                                                        <td>#{{ $ticket['tid'] }}</td>
                                                        <td>{{ $ticket['subject'] }}</td>
                                                        <td>{{ $ticket['deptname'] }}</td>
                                                        <td><span class="badge bg-info">{{ $ticket['status'] }}</span></td>
                                                        <td>{{ $ticket['lastreply'] }}</td>
                                                        <td>
                                                            @php
                                                                $localTicket = \App\Models\Ticket::where('whmcs_id', $ticket['id'])->first();
                                                            @endphp
                                                            @if($localTicket)
                                                                <a href="{{ route('accounting.tickets.show', $localTicket) }}"
                                                                    class="btn btn-sm btn-primary">عرض ورد</a>
                                                            @else
                                                                <span class="text-muted small">قم بالمزامنة للرد</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="6" class="text-center">لا توجد تذاكر مهارة.</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div> <!-- End tab-content -->
                    </div> <!-- End card-body -->
                </div> <!-- End glass-card -->
            </div> <!-- End col-md-9 -->
        </div> <!-- End row -->


        <!-- WhatsApp Modal -->
        <div class="modal fade" id="whatsappModal" tabindex="-1">
            <div class="modal-dialog">
                <form action="{{ route('customers.whatsapp.send', $customer) }}" method="POST">
                    @csrf
                    <div class="modal-content bg-dark">
                        <div class="modal-header border-secondary">
                            <h5 class="modal-title">إرسال رسالة واتساب</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">الرسالة</label>
                                <textarea name="message" class="form-control" rows="4" required></textarea>
                                <div class="form-text text-muted">
                                    إلى: {{ $customer->whatsapp ?: $customer->phone }}
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer border-secondary">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                            <button type="submit" class="btn btn-success"><i class="fab fa-whatsapp me-2"></i>إرسال</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Wallet Adjustment Modal -->
        <div class="modal fade" id="walletModal" tabindex="-1">
            <div class="modal-dialog">
                <form action="{{ route('customers.wallet.store', $customer) }}" method="POST" id="walletForm">
                    @csrf
                    <input type="hidden" name="_method" id="walletMethodInput" value="POST">
                    <div class="modal-content bg-dark border-secondary text-white">
                        <div class="modal-header border-secondary">
                            <h5 class="modal-title" id="walletModalTitle">تعديل المحفظة</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                onclick="resetWalletForm()"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">نوع العملية</label>
                                <select name="type" id="walletType" class="form-select bg-black text-white border-secondary"
                                    required>
                                    <option value="deposit">إيداع (إضافة للرصيد)</option>
                                    <option value="withdrawal">سحب (خصم من الرصيد)</option>
                                    <option value="adjustment">تعديل يدوي</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">المبلغ</label>
                                <input type="number" step="0.01" name="amount" id="walletAmount"
                                    class="form-control bg-black text-white border-secondary" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">الخزينة (اختياري)</label>
                                <select name="treasury_id" id="walletTreasury"
                                    class="form-select bg-black text-white border-secondary">
                                    <option value="">-- اختر الخزينة --</option>
                                    @foreach($treasuries as $treasury)
                                        <option value="{{ $treasury->id }}">{{ $treasury->name }}
                                            ({{ $treasury->currency->code ?? '' }})</option>
                                    @endforeach
                                </select>
                                <div class="form-text text-muted small">
                                    عند اختيار خزينة، سيتم تسجيل حركة مالية (إيداع/سحب) فيها تلقائياً.
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">وسيلة الدفع</label>
                                <input type="text" name="payment_method" id="walletMethod"
                                    class="form-control bg-black text-white border-secondary"
                                    placeholder="نقدي، تحويل بنكي، إلخ.">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">التاريخ</label>
                                <input type="date" name="date" id="walletDate"
                                    class="form-control bg-black text-white border-secondary" value="{{ date('Y-m-d') }}"
                                    required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">ملاحظات</label>
                                <textarea name="notes" id="walletNotes"
                                    class="form-control bg-black text-white border-secondary" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="modal-footer border-secondary">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                                onclick="resetWalletForm()">إلغاء</button>
                            <button type="submit" class="btn btn-primary" id="walletSubmitBtn">حفظ العملية</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Ticket Creation Modal -->
        <div class="modal fade" id="createTicketModal" tabindex="-1">
            <div class="modal-dialog">
                <form action="{{ route('accounting.tickets.store', $customer) }}" method="POST">
                    @csrf
                    <div class="modal-content bg-dark border-secondary text-white">
                        <div class="modal-header border-secondary">
                            <h5 class="modal-title">فتح تذكرة دعم فني جديدة</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">القسم</label>
                                <select name="deptid" class="form-select bg-black text-white border-secondary" required>
                                    <option value="1">الدعم الفني (Support)</option>
                                    <option value="2">المبيعات (Sales)</option>
                                    <option value="3">الحسابات (Billing)</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">عنوان التذكرة</label>
                                <input type="text" name="subject" class="form-control bg-black text-white border-secondary"
                                    required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">الأولوية</label>
                                <select name="priority" class="form-select bg-black text-white border-secondary" required>
                                    <option value="Low">منخفضة</option>
                                    <option value="Medium" selected>متوسطة</option>
                                    <option value="High">عالية</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">الرسالة</label>
                                <textarea name="message" class="form-control bg-black text-white border-secondary" rows="5"
                                    required></textarea>
                            </div>
                        </div>
                        <div class="modal-footer border-secondary">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">إرسال التذكرة</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Loyalty Modal -->
        <div class="modal fade" id="loyaltyModal" tabindex="-1">
            <div class="modal-dialog">
                <form action="{{ route('customers.loyalty.store', $customer) }}" method="POST" id="loyaltyForm">
                    @csrf
                    <input type="hidden" name="_method" id="loyaltyMethodInput" value="POST">
                    <div class="modal-content bg-dark border-secondary text-white">
                        <div class="modal-header border-secondary">
                            <h5 class="modal-title" id="loyaltyModalTitle">إضافة / خصم نقاط ولاء</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                onclick="resetLoyaltyForm()"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">النوع</label>
                                <select name="type" id="loyaltyType"
                                    class="form-select bg-black text-white border-secondary" required>
                                    <option value="earned">إضافة (Earned)</option>
                                    <option value="redeemed">خصم (Redeemed)</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">النقاط</label>
                                <input type="number" name="points" id="loyaltyPoints" min="1"
                                    class="form-control bg-black text-white border-secondary" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">الوصف</label>
                                <input type="text" name="description" id="loyaltyDesc"
                                    class="form-control bg-black text-white border-secondary" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">التاريخ</label>
                                <input type="date" name="date" id="loyaltyDate" value="{{ date('Y-m-d') }}"
                                    class="form-control bg-black text-white border-secondary" required>
                            </div>
                        </div>
                        <div class="modal-footer border-secondary">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                                onclick="resetLoyaltyForm()">إلغاء</button>
                            <button type="submit" class="btn btn-primary" id="loyaltySubmitBtn">حفظ</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <script>


            function copyLoginLink() {
                var copyText = document.getElementById("loginLink");
                navigator.clipboard.writeText(copyText.value).then(function () {
                    alert("تم نسخ رابط تسجيل الدخول (الهاتف) بنجاح!");
                });
            }

            function sendSerialWhatsapp(serialKey, softwareName) {
                if (!confirm('هل أنت متأكد من إرسال هذا السيريال للعميل عبر الواتساب؟')) return;

                fetch("{{ route('accounting.licenses.whatsapp', $customer) }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        serial_key: serialKey,
                        software_name: softwareName
                    })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert(data.message);
                        } else {
                            alert('Error: ' + data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('حدث خطأ أثناء إرسال الرسالة.');
                    });
            }

            function editNote(noteId, noteContent) {
                // Determine raw note content (handling any encoding if passed safely)
                // In blade we used addslashes, so it should be a valid string

                document.getElementById('noteText').value = noteContent;
                document.getElementById('noteMethod').value = 'PUT';
                document.getElementById('noteLabel').innerText = 'تعديل ملاحظة';
                document.getElementById('saveNoteBtn').innerText = 'تحديث الملاحظة';
                document.getElementById('cancelNoteEdit').classList.remove('d-none');

                // Update form action
                // Base: /customers/{id}/notes/{noteId}
                var updateUrl = "{{ route('customers.notes.update', [$customer, ':id']) }}";
                updateUrl = updateUrl.replace(':id', noteId);
                document.getElementById('noteForm').action = updateUrl;

                // Scroll to form
                document.getElementById('noteForm').scrollIntoView({ behavior: 'smooth' });
            }

            function resetNoteForm() {
                document.getElementById('noteText').value = '';
                document.getElementById('noteMethod').value = 'POST';
                document.getElementById('noteLabel').innerText = 'إضافة ملاحظة';
                document.getElementById('saveNoteBtn').innerText = 'إضافة ملاحظة';
                document.getElementById('cancelNoteEdit').classList.add('d-none');

                document.getElementById('noteForm').action = "{{ route('customers.notes.store', $customer) }}";
            }

            function editWalletTransaction(id, type, amount, method, date, notes) {
                document.getElementById('walletForm').action = "{{ route('customers.wallet.update', [$customer, ':id']) }}".replace(':id', id);
                document.getElementById('walletMethodInput').value = 'PUT';
                document.getElementById('walletTitle').innerText = 'تعديل المعاملة';
                document.getElementById('walletSubmitBtn').innerText = 'تحديث';

                document.getElementById('walletType').value = type;
                document.getElementById('walletAmount').value = amount;
                document.getElementById('walletMethod').value = method;
                document.getElementById('walletDate').value = date;
                document.getElementById('walletNotes').value = notes;

                // Show modal
                var myModal = new bootstrap.Modal(document.getElementById('walletModal'));
                myModal.show();
            }

            function resetWalletForm() {
                document.getElementById('walletForm').action = "{{ route('customers.wallet.store', $customer) }}";
                document.getElementById('walletMethodInput').value = 'POST';
                document.getElementById('walletTitle').innerText = 'تعديل المحفظة';
                document.getElementById('walletSubmitBtn').innerText = 'حفظ العملية';
                document.getElementById('walletForm').reset();
                // Reset date to today
                document.getElementById('walletDate').value = new Date().toISOString().split('T')[0];
            }

            function editLoyaltyTransaction(id, points, type, description, date) {
                document.getElementById('loyaltyForm').action = "{{ route('customers.loyalty.update', [$customer, ':id']) }}".replace(':id', id);
                document.getElementById('loyaltyMethodInput').value = 'PUT';
                document.getElementById('loyaltyTitle').innerText = 'تعديل النقاط'; // Need to add ID to title in replacement above
                document.getElementById('loyaltySubmitBtn').innerText = 'تحديث';

                document.getElementById('loyaltyType').value = type;
                document.getElementById('loyaltyPoints').value = points;
                document.getElementById('loyaltyDesc').value = description;
                document.getElementById('loyaltyDate').value = date;

                // Show modal
                var myModal = new bootstrap.Modal(document.getElementById('loyaltyModal'));
                myModal.show();
            }

            function resetLoyaltyForm() {
                document.getElementById('loyaltyForm').action = "{{ route('customers.loyalty.store', $customer) }}";
                document.getElementById('loyaltyMethodInput').value = 'POST';
                document.getElementById('loyaltyTitle').innerText = 'إضافة / خصم نقاط ولاء';
                document.getElementById('loyaltySubmitBtn').innerText = 'حفظ';
                document.getElementById('loyaltyForm').reset();
                document.getElementById('loyaltyDate').value = new Date().toISOString().split('T')[0];
            }

        </script>
@endsection