@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div>
                <h2 class="fw-light">{{ __('Attendance Management') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('hr.employees.index') }}">{{ __('HR') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Attendance') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex gap-2 align-items-center">
                <form action="" method="GET" class="d-flex gap-2">
                    <input type="date" name="date" value="{{ $date }}"
                        class="form-control bg-dark text-white border-secondary">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter"></i></button>
                </form>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card bg-dark border-secondary">
        <div class="card-header border-secondary d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-calendar-check me-2"></i>{{ __('Attendance for') }}
                {{ \Carbon\Carbon::parse($date)->format('M d, Y') }}</h5>
            <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#bulkCheckInModal">
                <i class="fas fa-user-clock me-1"></i>{{ __('Bulk Check-In') }}
            </button>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dark table-hover mb-0 align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Employee') }}</th>
                            <th>{{ __('Department') }}</th>
                            <th class="text-center">{{ __('Check In') }}</th>
                            <th class="text-center">{{ __('Check Out') }}</th>
                            <th class="text-center">{{ __('Status') }}</th>
                            <th class="text-center">{{ __('Work Hours') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($employees as $employee)
                            @php
                                $attendance = $attendances->get($employee->id);
                                $statusClass = match ($attendance?->status ?? 'absent') {
                                    'present' => 'success',
                                    'late' => 'warning',
                                    'absent' => 'danger',
                                    'on_leave' => 'info',
                                    'half_day' => 'secondary',
                                    default => 'secondary'
                                };
                            @endphp
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-circle bg-primary text-white me-2">
                                            {{ strtoupper(substr($employee->first_name, 0, 1)) }}
                                        </div>
                                        <div>
                                            <div class="fw-bold">{{ $employee->full_name }}</div>
                                            <small
                                                class="text-muted">{{ $employee->assignedDesignation->name ?? $employee->job_title ?? '-' }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $employee->assignedDepartment->name ?? $employee->department ?? '-' }}</td>
                                <td class="text-center">
                                    {{ $attendance?->check_in ?? '-' }}
                                </td>
                                <td class="text-center">
                                    {{ $attendance?->check_out ?? '-' }}
                                </td>
                                <td class="text-center">
                                    <span
                                        class="badge bg-{{ $statusClass }}">{{ __(ucfirst(str_replace('_', ' ', $attendance?->status ?? 'absent'))) }}</span>
                                </td>
                                <td class="text-center">
                                    {{ $attendance ? number_format($attendance->work_hours, 1) . ' ' . __('hrs') : '-' }}
                                </td>
                                <td class="text-end">
                                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal"
                                        data-bs-target="#attendanceModal{{ $employee->id }}">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    @if($attendance && !$attendance->check_out)
                                        <form action="{{ route('hr.attendance.checkout', $employee) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-outline-warning">
                                                <i class="fas fa-sign-out-alt"></i>
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>

                            <!-- Attendance Modal -->
                            <div class="modal fade" id="attendanceModal{{ $employee->id }}" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content bg-dark text-white">
                                        <form action="{{ route('hr.attendance.store') }}" method="POST">
                                            @csrf
                                            <input type="hidden" name="employee_id" value="{{ $employee->id }}">
                                            <input type="hidden" name="date" value="{{ $date }}">
                                            <div class="modal-header border-secondary">
                                                <h5 class="modal-title">{{ __('Record Attendance') }} -
                                                    {{ $employee->full_name }}</h5>
                                                <button type="button" class="btn-close btn-close-white"
                                                    data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="row g-3">
                                                    <div class="col-6">
                                                        <label class="form-label">{{ __('Check In') }}</label>
                                                        <input type="time" name="check_in"
                                                            class="form-control bg-dark text-white border-secondary"
                                                            value="{{ $attendance?->check_in }}">
                                                    </div>
                                                    <div class="col-6">
                                                        <label class="form-label">{{ __('Check Out') }}</label>
                                                        <input type="time" name="check_out"
                                                            class="form-control bg-dark text-white border-secondary"
                                                            value="{{ $attendance?->check_out }}">
                                                    </div>
                                                    <div class="col-12">
                                                        <label class="form-label">{{ __('Status') }}</label>
                                                        <select name="status"
                                                            class="form-select bg-dark text-white border-secondary">
                                                            <option value="present" {{ ($attendance?->status ?? '') == 'present' ? 'selected' : '' }}>{{ __('Present') }}</option>
                                                            <option value="late" {{ ($attendance?->status ?? '') == 'late' ? 'selected' : '' }}>{{ __('Late') }}</option>
                                                            <option value="absent" {{ ($attendance?->status ?? '') == 'absent' ? 'selected' : '' }}>{{ __('Absent') }}</option>
                                                            <option value="on_leave" {{ ($attendance?->status ?? '') == 'on_leave' ? 'selected' : '' }}>{{ __('On Leave') }}</option>
                                                            <option value="half_day" {{ ($attendance?->status ?? '') == 'half_day' ? 'selected' : '' }}>{{ __('Half Day') }}</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-12">
                                                        <label class="form-label">{{ __('Notes') }}</label>
                                                        <textarea name="notes" rows="2"
                                                            class="form-control bg-dark text-white border-secondary">{{ $attendance?->notes }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer border-secondary">
                                                <button type="button" class="btn btn-secondary"
                                                    data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                                <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted">
                                    <i class="fas fa-users fa-3x mb-3 opacity-50"></i>
                                    <p>{{ __('No active employees found.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bulk Check-In Modal -->
    <div class="modal fade" id="bulkCheckInModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-dark text-white">
                <form action="{{ route('hr.attendance.bulk-checkin') }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><i class="fas fa-users me-2"></i>{{ __('Bulk Check-In') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p class="text-muted mb-3">{{ __('Select employees to check in at the current time.') }}</p>
                        <div class="row g-2">
                            @foreach($employees as $employee)
                                @if(!$attendances->has($employee->id) || !$attendances->get($employee->id)->check_in)
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="employee_ids[]"
                                                value="{{ $employee->id }}" id="bulk{{ $employee->id }}">
                                            <label class="form-check-label" for="bulk{{ $employee->id }}">
                                                {{ $employee->full_name }} <small
                                                    class="text-muted">({{ $employee->assignedDepartment->name ?? '-' }})</small>
                                            </label>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-success"><i
                                class="fas fa-check me-1"></i>{{ __('Check In Selected') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <style>
        .avatar-circle {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 0.9rem;
        }
    </style>
@endsection