@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Employee') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('hr.employees.index') }}">{{ __('Employees') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $employee->full_name }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <form action="{{ route('hr.employees.update', $employee->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="card bg-dark border-secondary">
            <div class="card-header border-secondary d-flex justify-content-between align-items-center">
                <h5 class="mb-0">{{ __('Edit Details') }}</h5>
                <span
                    class="badge bg-{{ $employee->status == 'active' ? 'success' : 'secondary' }}">{{ __($employee->status) }}</span>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <!-- Personal Info -->
                    <div class="col-12">
                        <h6 class="text-primary mb-3"><i class="fas fa-user me-2"></i>{{ __('Personal Information') }}</h6>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('First Name') }} <span class="text-danger">*</span></label>
                        <input type="text" name="first_name" class="form-control" required
                            value="{{ old('first_name', $employee->first_name) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Last Name') }} <span class="text-danger">*</span></label>
                        <input type="text" name="last_name" class="form-control" required
                            value="{{ old('last_name', $employee->last_name) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Email Address') }} <span class="text-danger">*</span></label>
                        <input type="email" name="email" class="form-control" required
                            value="{{ old('email', $employee->email) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Phone Number') }}</label>
                        <input type="text" name="phone" class="form-control" value="{{ old('phone', $employee->phone) }}">
                    </div>
                    <div class="col-md-12">
                        <label class="form-label">{{ __('Address') }}</label>
                        <textarea name="address" class="form-control"
                            rows="2">{{ old('address', $employee->address) }}</textarea>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Emergency Contact') }}</label>
                        <input type="text" name="emergency_contact" class="form-control"
                            value="{{ old('emergency_contact', $employee->emergency_contact) }}"
                            placeholder="{{ __('Name & Phone') }}">
                    </div>

                    <div class="col-12 mt-4">
                        <h6 class="text-primary mb-3"><i class="fas fa-briefcase me-2"></i>{{ __('Job Details') }}</h6>
                    </div>
                    <!-- Job Info -->
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Department') }}</label>
                        <select name="department_id" class="form-select">
                            <option value="">{{ __('Select Department') }}</option>
                            @foreach($departments as $department)
                                <option value="{{ $department->id }}" {{ (old('department_id', $employee->department_id) == $department->id) ? 'selected' : '' }}>
                                    {{ $department->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Designation') }}</label>
                        <select name="designation_id" class="form-select">
                            <option value="">{{ __('Select Designation') }}</option>
                            @foreach($designations as $designation)
                                <option value="{{ $designation->id }}" {{ (old('designation_id', $employee->designation_id) == $designation->id) ? 'selected' : '' }}>
                                    {{ $designation->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Joining Date') }}</label>
                        <input type="date" name="joining_date" class="form-control"
                            value="{{ old('joining_date', $employee->joining_date?->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Hire Date') }}</label>
                        <input type="date" name="hire_date" class="form-control"
                            value="{{ old('hire_date', $employee->hire_date?->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Status') }} <span class="text-danger">*</span></label>
                        <select name="status" class="form-select w-25">
                            <option value="active" {{ $employee->status == 'active' ? 'selected' : '' }}>{{ __('Active') }}
                            </option>
                            <option value="on_leave" {{ $employee->status == 'on_leave' ? 'selected' : '' }}>
                                {{ __('On Leave') }}
                            </option>
                            <option value="resigned" {{ $employee->status == 'resigned' ? 'selected' : '' }}>
                                {{ __('Resigned') }}
                            </option>
                            <option value="terminated" {{ $employee->status == 'terminated' ? 'selected' : '' }}>
                                {{ __('Terminated') }}
                            </option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Shift Type') }}</label>
                        <select name="shift_type" class="form-select">
                            <option value="day" {{ old('shift_type', $employee->shift_type) == 'day' ? 'selected' : '' }}>
                                {{ __('Day Shift') }}</option>
                            <option value="night" {{ old('shift_type', $employee->shift_type) == 'night' ? 'selected' : '' }}>
                                {{ __('Night Shift') }}</option>
                            <option value="flexible" {{ old('shift_type', $employee->shift_type) == 'flexible' ? 'selected' : '' }}>{{ __('Flexible') }}</option>
                        </select>
                    </div>

                    <div class="col-12 mt-4">
                        <h6 class="text-primary mb-3"><i
                                class="fas fa-money-bill-wave me-2"></i>{{ __('Financial Information') }}</h6>
                    </div>
                    <!-- Financial Info -->
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Basic Salary (Monthly)') }} <span
                                class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text bg-secondary text-white border-secondary">{{ __('EGP') }}</span>
                            <input type="number" name="basic_salary" class="form-control" step="0.01" required
                                value="{{ old('basic_salary', $employee->basic_salary) }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('Hourly Rate') }}</label>
                        <div class="input-group">
                            <span class="input-group-text bg-secondary text-white border-secondary">EGP</span>
                            <input type="number" name="hourly_rate" class="form-control" step="0.01"
                                value="{{ old('hourly_rate', $employee->hourly_rate) }}">
                        </div>
                    </div>

                    <div class="col-md-12 mt-3">
                        <label class="form-label">{{ __('Notes') }}</label>
                        <textarea name="notes" class="form-control" rows="3">{{ old('notes', $employee->notes) }}</textarea>
                    </div>
                </div>

                <div class="mt-4 text-end">
                    <button type="button" class="btn btn-outline-danger me-auto float-start"
                        onclick="if(confirm('{{ __('Delete employee? This cannot be undone.') }}')) document.getElementById('delete-form').submit();">
                        <i class="fas fa-trash me-2"></i>{{ __('Delete') }}
                    </button>
                    <a href="{{ route('hr.employees.index') }}" class="btn btn-secondary me-2">{{ __('Cancel') }}</a>
                    <button type="submit" class="btn btn-primary">{{ __('Update Details') }}</button>
                </div>
            </div>
        </div>
    </form>

    <form id="delete-form" action="{{ route('hr.employees.destroy', $employee->id) }}" method="POST" class="d-none">
        @csrf
        @method('DELETE')
    </form>
@endsection