@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-light">{{ __('Employees') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('HR & Payroll') }}</li>
                    </ol>
                </nav>
            </div>
            <div>
                <a href="{{ route('hr.employees.create') }}" class="btn btn-primary">
                    <i class="fas fa-user-plus me-2"></i>{{ __('Add Employee') }}
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row g-4 mb-4">
        <div class="col-6 col-md-4">
            <div class="card bg-dark border-secondary">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Total Employees') }}</h6>
                    <h3 class="fw-bold mb-0">{{ $totalEmployees }}</h3>
                </div>
            </div>
        </div>
        <div class="col-6 col-md-4">
            <div class="card bg-dark border-secondary">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Active Staff') }}</h6>
                    <h3 class="fw-bold text-success mb-0">{{ $activeEmployees }}</h3>
                </div>
            </div>
        </div>
        <!-- Payroll placeholder for future -->
        <div class="col-6 col-md-4">
            <div class="card bg-dark border-secondary opacity-50">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Monthly Payroll') }}</h6>
                    <h3 class="fw-bold mb-0">{{ __('Coming Soon') }}</h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-header border-secondary d-flex justify-content-between align-items-center">
            <h5 class="mb-0">{{ __('Employee List') }}</h5>
            <div class="d-flex gap-2">
                <input type="text" class="form-control form-control-sm bg-dark text-white border-secondary"
                    placeholder="{{ __('Search...') }}">
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark mb-0 align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Name / Email') }}</th>
                            <th>{{ __('Designation') }}</th>
                            <th>{{ __('Department') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Joining Date') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($employees as $employee)
                                            <tr>
                                                <td data-label="{{ __('Name / Email') }}">
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-circle bg-primary text-white me-3">
                                                            {{ strtoupper(substr($employee->first_name, 0, 1)) }}
                                                        </div>
                                                        <div>
                                                            <div class="fw-bold">{{ $employee->full_name }}</div>
                                                            <div class="small text-muted">{{ $employee->email }}</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td data-label="{{ __('Designation') }}">
                                                    {{ $employee->assignedDesignation->name ?? $employee->job_title ?? '-' }}</td>
                                                <td data-label="{{ __('Department') }}"><span
                                                        class="badge bg-secondary">{{ $employee->assignedDepartment->name ?? $employee->department ?? '-' }}</span>
                                                </td>
                                                <td data-label="{{ __('Status') }}">
                                                    @php
                                                        $statusClass = match ($employee->status) {
                                                            'active' => 'success',
                                                            'resigned' => 'warning',
                                                            'terminated' => 'danger',
                                                            'on_leave' => 'info',
                                                            default => 'secondary'
                                                        };
                                                    @endphp
                             <span
                                                        class="badge bg-{{ $statusClass }}">{{ __(ucfirst(str_replace('_', ' ', $employee->status))) }}</span>
                                                </td>
                                                <td data-label="{{ __('Joining Date') }}">
                                                    {{ $employee->joining_date ? $employee->joining_date->format('M d, Y') : ($employee->hire_date ? $employee->hire_date->format('M d, Y') : '-') }}
                                                </td>
                                                <td data-label="{{ __('Actions') }}" class="text-end">
                                                    <a href="{{ route('hr.employees.edit', $employee->id) }}"
                                                        class="btn btn-sm btn-outline-info">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    <i class="fas fa-users fa-3x mb-3 opacity-50"></i>
                                    <p>{{ __('No employees found. Start by adding one.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center mt-3">
                {{ $employees->links() }}
            </div>
        </div>
    </div>

    <style>
        .avatar-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
    </style>
@endsection