@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div>
                <h2 class="fw-light">{{ __('Payroll Management') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('hr.employees.index') }}">{{ __('HR') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Payroll') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex gap-2">
                <form action="" method="GET" class="d-flex gap-2">
                    <input type="month" name="month" value="{{ $month }}"
                        class="form-control bg-dark text-white border-secondary">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter"></i></button>
                </form>
                <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#generateModal">
                    <i class="fas fa-plus me-1"></i>{{ __('Generate Payroll') }}
                </button>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card bg-dark border-secondary">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Total Payrolls') }}</h6>
                    <h3 class="fw-bold mb-0">{{ $payrolls->total() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Total Net Salary') }}</h6>
                    <h3 class="fw-bold text-success mb-0">{{ number_format($payrolls->sum('net_salary'), 2) }}
                        {{ __('EGP') }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Paid') }}</h6>
                    <h3 class="fw-bold text-info mb-0">{{ $payrolls->where('status', 'paid')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark border-secondary">
                <div class="card-body">
                    <h6 class="text-muted text-uppercase mb-2">{{ __('Pending') }}</h6>
                    <h3 class="fw-bold text-warning mb-0">{{ $payrolls->whereIn('status', ['draft', 'approved'])->count() }}
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-header border-secondary">
            <h5 class="mb-0"><i class="fas fa-money-check-alt me-2"></i>{{ __('Payroll for') }}
                {{ \Carbon\Carbon::parse($month . '-01')->format('F Y') }}</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dark table-hover mb-0 align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Employee') }}</th>
                            <th class="text-end">{{ __('Basic Salary') }}</th>
                            <th class="text-end">{{ __('Allowances') }}</th>
                            <th class="text-end">{{ __('Deductions') }}</th>
                            <th class="text-end">{{ __('Net Salary') }}</th>
                            <th class="text-center">{{ __('Status') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($payrolls as $payroll)
                            @php
                                $statusClass = match ($payroll->status) {
                                    'draft' => 'secondary',
                                    'approved' => 'warning',
                                    'paid' => 'success',
                                    default => 'secondary'
                                };
                            @endphp
                            <tr>
                                <td>
                                    <div class="fw-bold">{{ $payroll->employee->full_name }}</div>
                                    <small
                                        class="text-muted">{{ $payroll->employee->assignedDesignation->name ?? $payroll->employee->job_title ?? '-' }}</small>
                                </td>
                                <td class="text-end">{{ number_format($payroll->basic_salary, 2) }}</td>
                                <td class="text-end text-success">+{{ number_format($payroll->total_allowances, 2) }}</td>
                                <td class="text-end text-danger">-{{ number_format($payroll->total_deductions, 2) }}</td>
                                <td class="text-end fw-bold">{{ number_format($payroll->net_salary, 2) }}</td>
                                <td class="text-center">
                                    <span class="badge bg-{{ $statusClass }}">{{ __(ucfirst($payroll->status)) }}</span>
                                </td>
                                <td class="text-end">
                                    <a href="{{ route('hr.payroll.show', $payroll) }}" class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5 text-muted">
                                    <i class="fas fa-money-check-alt fa-3x mb-3 opacity-50"></i>
                                    <p>{{ __('No payroll records for this month. Generate payroll to get started.') }}</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center mt-3 pb-3">
                {{ $payrolls->appends(['month' => $month])->links() }}
            </div>
        </div>
    </div>

    <!-- Generate Payroll Modal -->
    <div class="modal fade" id="generateModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content bg-dark text-white">
                <form action="{{ route('hr.payroll.generate') }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><i class="fas fa-cog me-2"></i>{{ __('Generate Payroll') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Period Month') }}</label>
                            <input type="month" name="period_month" class="form-control bg-dark text-white border-secondary"
                                value="{{ $month }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Employees') }} <small
                                    class="text-muted">({{ __('Leave empty for all active employees') }})</small></label>
                            <div class="row g-2" style="max-height: 300px; overflow-y: auto;">
                                @foreach($employees as $employee)
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="employee_ids[]"
                                                value="{{ $employee->id }}" id="emp{{ $employee->id }}">
                                            <label class="form-check-label" for="emp{{ $employee->id }}">
                                                {{ $employee->full_name }} <small
                                                    class="text-success">({{ number_format($employee->basic_salary ?? 0, 2) }})</small>
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-success"><i
                                class="fas fa-cogs me-1"></i>{{ __('Generate') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection