@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div>
                <h2 class="fw-light">{{ __('Payslip') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('hr.payroll.index') }}">{{ __('Payroll') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $payroll->employee->full_name }}</li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex gap-2">
                @if($payroll->status === 'draft')
                    <form action="{{ route('hr.payroll.approve', $payroll) }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-warning"><i
                                class="fas fa-check me-1"></i>{{ __('Approve') }}</button>
                    </form>
                @elseif($payroll->status === 'approved')
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#payModal">
                        <i class="fas fa-money-bill-wave me-1"></i>{{ __('Mark as Paid') }}
                    </button>
                @endif
                <a href="{{ route('hr.payroll.index', ['month' => $payroll->period_month]) }}"
                    class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-1"></i>{{ __('Back') }}
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        <!-- Employee Info -->
        <div class="col-md-4">
            <div class="card bg-dark border-secondary h-100">
                <div class="card-header border-secondary">
                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>{{ __('Employee Info') }}</h5>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        <div class="avatar-circle-lg bg-primary text-white mx-auto mb-2">
                            {{ strtoupper(substr($payroll->employee->first_name, 0, 1)) }}{{ strtoupper(substr($payroll->employee->last_name, 0, 1)) }}
                        </div>
                        <h5>{{ $payroll->employee->full_name }}</h5>
                        <p class="text-muted mb-0">
                            {{ $payroll->employee->assignedDesignation->name ?? $payroll->employee->job_title ?? '-' }}</p>
                    </div>
                    <hr class="border-secondary">
                    <dl class="row mb-0">
                        <dt class="col-5 text-muted">{{ __('Period') }}</dt>
                        <dd class="col-7">{{ \Carbon\Carbon::parse($payroll->period_month . '-01')->format('F Y') }}</dd>
                        <dt class="col-5 text-muted">{{ __('Department') }}</dt>
                        <dd class="col-7">{{ $payroll->employee->assignedDepartment->name ?? '-' }}</dd>
                        <dt class="col-5 text-muted">{{ __('Status') }}</dt>
                        <dd class="col-7">
                            @php
                                $statusClass = match ($payroll->status) {
                                    'draft' => 'secondary',
                                    'approved' => 'warning',
                                    'paid' => 'success',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $statusClass }}">{{ __(ucfirst($payroll->status)) }}</span>
                        </dd>
                        @if($payroll->payment_date)
                            <dt class="col-5 text-muted">{{ __('Paid On') }}</dt>
                            <dd class="col-7">{{ $payroll->payment_date->format('M d, Y') }}</dd>
                        @endif
                    </dl>
                </div>
            </div>
        </div>

        <!-- Salary Breakdown -->
        <div class="col-md-8">
            <div class="card bg-dark border-secondary mb-4">
                <div class="card-header border-secondary d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-calculator me-2"></i>{{ __('Salary Breakdown') }}</h5>
                    @if($payroll->status !== 'paid')
                        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal"
                            data-bs-target="#addItemModal">
                            <i class="fas fa-plus me-1"></i>{{ __('Add Item') }}
                        </button>
                    @endif
                </div>
                <div class="card-body p-0">
                    <table class="table table-dark mb-0">
                        <tbody>
                            <tr>
                                <td class="fw-bold">{{ __('Basic Salary') }}</td>
                                <td class="text-end">{{ number_format($payroll->basic_salary, 2) }} {{ __('EGP') }}</td>
                            </tr>
                            @foreach($payroll->items->where('type', 'allowance') as $item)
                                <tr class="text-success">
                                    <td><i class="fas fa-plus-circle me-2"></i>{{ $item->description }} ({{ __('Allowance') }})
                                    </td>
                                    <td class="text-end">
                                        +{{ number_format($item->amount, 2) }}
                                        @if($payroll->status !== 'paid')
                                            <form action="{{ route('hr.payroll.remove-item', [$payroll, $item]) }}" method="POST"
                                                class="d-inline">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-link text-danger p-0 ms-2"><i
                                                        class="fas fa-times"></i></button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            @foreach($payroll->items->where('type', 'bonus') as $item)
                                <tr class="text-info">
                                    <td><i class="fas fa-gift me-2"></i>{{ $item->description }} ({{ __('Bonus') }})</td>
                                    <td class="text-end">
                                        +{{ number_format($item->amount, 2) }}
                                        @if($payroll->status !== 'paid')
                                            <form action="{{ route('hr.payroll.remove-item', [$payroll, $item]) }}" method="POST"
                                                class="d-inline">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-link text-danger p-0 ms-2"><i
                                                        class="fas fa-times"></i></button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            @foreach($payroll->items->where('type', 'deduction') as $item)
                                <tr class="text-danger">
                                    <td><i class="fas fa-minus-circle me-2"></i>{{ $item->description }} ({{ __('Deduction') }})
                                    </td>
                                    <td class="text-end">
                                        -{{ number_format($item->amount, 2) }}
                                        @if($payroll->status !== 'paid')
                                            <form action="{{ route('hr.payroll.remove-item', [$payroll, $item]) }}" method="POST"
                                                class="d-inline">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-link text-danger p-0 ms-2"><i
                                                        class="fas fa-times"></i></button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            @foreach($payroll->items->where('type', 'penalty') as $item)
                                <tr class="text-warning">
                                    <td><i class="fas fa-exclamation-triangle me-2"></i>{{ $item->description }}
                                        ({{ __('Penalty') }})</td>
                                    <td class="text-end">
                                        -{{ number_format($item->amount, 2) }}
                                        @if($payroll->status !== 'paid')
                                            <form action="{{ route('hr.payroll.remove-item', [$payroll, $item]) }}" method="POST"
                                                class="d-inline">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-link text-danger p-0 ms-2"><i
                                                        class="fas fa-times"></i></button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="border-top border-secondary">
                            <tr>
                                <td class="fw-bold text-success fs-5">{{ __('Total Allowances') }}</td>
                                <td class="text-end fw-bold text-success fs-5">
                                    +{{ number_format($payroll->total_allowances, 2) }} {{ __('EGP') }}</td>
                            </tr>
                            <tr>
                                <td class="fw-bold text-danger fs-5">{{ __('Total Deductions') }}</td>
                                <td class="text-end fw-bold text-danger fs-5">
                                    -{{ number_format($payroll->total_deductions, 2) }} {{ __('EGP') }}</td>
                            </tr>
                            <tr class="bg-primary bg-opacity-25">
                                <td class="fw-bold fs-4">{{ __('Net Salary') }}</td>
                                <td class="text-end fw-bold fs-4">{{ number_format($payroll->net_salary, 2) }}
                                    {{ __('EGP') }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Item Modal -->
    <div class="modal fade" id="addItemModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <form action="{{ route('hr.payroll.add-item', $payroll) }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><i class="fas fa-plus me-2"></i>{{ __('Add Payroll Item') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Type') }}</label>
                            <select name="type" class="form-select bg-dark text-white border-secondary" required>
                                <option value="allowance">{{ __('Allowance') }}</option>
                                <option value="bonus">{{ __('Bonus') }}</option>
                                <option value="deduction">{{ __('Deduction') }}</option>
                                <option value="penalty">{{ __('Penalty') }}</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Description') }}</label>
                            <input type="text" name="description" class="form-control bg-dark text-white border-secondary"
                                required placeholder="{{ __('e.g., Transportation Allowance') }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Amount') }} ({{ __('EGP') }})</label>
                            <input type="number" step="0.01" min="0" name="amount"
                                class="form-control bg-dark text-white border-secondary" required>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Add Item') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Pay Modal -->
    <div class="modal fade" id="payModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <form action="{{ route('hr.payroll.pay', $payroll) }}" method="POST">
                    @csrf
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title"><i class="fas fa-money-bill-wave me-2"></i>{{ __('Mark as Paid') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            {{ __('This will mark the payroll as paid. Amount:') }}
                            <strong>{{ number_format($payroll->net_salary, 2) }} {{ __('EGP') }}</strong>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Pay From Treasury') }}</label>
                            <select name="treasury_id" class="form-select bg-dark text-white border-secondary" required>
                                @foreach(\App\Models\Treasury::where('is_active', true)->get() as $treasury)
                                    <option value="{{ $treasury->id }}">{{ $treasury->name }}
                                        ({{ number_format($treasury->balance, 2) }})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-success"><i
                                class="fas fa-check me-1"></i>{{ __('Confirm Payment') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <style>
        .avatar-circle-lg {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 1.5rem;
        }
    </style>
@endsection