<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}"
    data-bs-theme="dark">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'SmartOneGroup ERP') }}</title>

    <script>
        window.APP_URL = "{{ url('/') }}";
    </script>

    <!-- Google Fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Tajawal:wght@300;400;500;700;800;900&display=swap"
        rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        :root {
            --sidebar-bg: #0a0e14;
            --main-bg: #0f1318;
            --card-bg: rgba(20, 25, 32, 0.8);
            --accent-cyan: #00d4ff;
            --accent-purple: #8b5cf6;
            --accent-pink: #ec4899;
            --accent-green: #10b981;
            --accent-orange: #f97316;
            --accent-yellow: #fbbf24;
            --accent-red: #ef4444;
            --accent-blue: #3b82f6;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
            --glass-hover: rgba(255, 255, 255, 0.06);
            --gradient-primary: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
    </style>
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family:
                {{ app()->getLocale() == 'ar' ? "'Tajawal', 'Inter'" : "'Inter'" }}
                , -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--main-bg);
            color: #e2e8f0;
            overflow-x: hidden;
            width: 100%;
            min-height: 100vh;
        }

        /* Glassmorphism Classes */
        .glass-card {
            background: var(--glass-bg);
            backdrop-filter: blur(12px) saturate(180%);
            -webkit-backdrop-filter: blur(12px) saturate(180%);
            border: 1px solid var(--glass-border);
            border-radius: 20px;
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
            transition: all 0.3s ease;
        }

        .glass-card:hover {
            background: var(--glass-hover);
            border-color: rgba(255, 255, 255, 0.15);
            transform: translateY(-5px);
        }

        .premium-shadow {
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.4);
        }

        .animated-gradient-text {
            background: linear-gradient(90deg, var(--accent-cyan), var(--accent-purple), var(--accent-pink), var(--accent-cyan));
            background-size: 300% auto;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            animation: shine 5s linear infinite;
        }

        @keyframes shine {
            to {
                background-position: 300% center;
            }
        }

        /* Chart Tooltip Style */
        .chart-tooltip {
            background: rgba(10, 14, 20, 0.9) !important;
            backdrop-filter: blur(8px) !important;
            border: 1px solid var(--glass-border) !important;
            border-radius: 8px !important;
            padding: 10px !important;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 20% 80%, rgba(139, 92, 246, 0.05) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(0, 212, 255, 0.05) 0%, transparent 50%);
            pointer-events: none;
            z-index: -1;
        }

        .wrapper {
            display: flex;
            width: 100%;
            min-height: 100vh;
        }

        .sidebar {
            width: 280px;
            height: 100vh;
            background: var(--sidebar-bg);
            border-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}: 1px solid var(--glass-border);
            position: fixed;
            {{ app()->getLocale() == 'ar' ? 'right' : 'left' }}
            : 0;
            top: 0;
            z-index: 1000;
            display: flex;
            flex-direction: column;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .sidebar-header {
            padding: 25px 20px;
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.1), rgba(0, 212, 255, 0.1));
            border-bottom: 1px solid var(--glass-border);
            flex-shrink: 0;
        }

        .sidebar-header h3 {
            background: linear-gradient(135deg, var(--accent-cyan), var(--accent-purple));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 800;
            letter-spacing: 2px;
            font-size: 1.4rem;
        }

        /* Sidebar Scroll */
        .sidebar-content {
            flex: 1;
            overflow-y: auto;
            padding-bottom: 40px;
            scrollbar-width: thin;
            scrollbar-color: var(--accent-purple) transparent;
        }

        /* Webkit Scrollbar */
        .sidebar-content::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar-content::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar-content::-webkit-scrollbar-thumb {
            background-color: var(--accent-purple);
            border-radius: 20px;
        }

        .nav-header {
            font-size: 0.7rem;
            font-weight: 700;
            color: #64748b;
            letter-spacing: 2px;
            text-transform: uppercase;
            padding: 20px 20px 10px;
        }

        .nav-link {
            padding: 12px 20px;
            color: #94a3b8;
            display: flex;
            align-items: center;
            gap: 12px;
            border-radius: 12px;
            margin: 3px 12px;
            transition: all 0.25s ease;
            font-weight: 500;
            font-size: 0.9rem;
        }

        .nav-link:hover {
            color: #fff;
            background: var(--glass-hover);
            transform: translateX({{ app()->getLocale() == 'ar' ? '-5px' : '5px' }});
        }

        .nav-link.active {
            color: #fff;
            background: linear-gradient(90deg, rgba(139, 92, 246, 0.3), rgba(0, 212, 255, 0.1));
        }

        .nav-link i {
            font-size: 1rem;
            width: 24px;
            text-align: center;
        }

        .nav-link .icon-crm {
            color: var(--accent-cyan);
        }

        .nav-link .icon-finance {
            color: var(--accent-green);
        }

        .nav-link .icon-invest {
            color: var(--accent-yellow);
        }

        .nav-link .icon-procurement {
            color: var(--accent-orange);
        }

        .nav-link .icon-analytics {
            color: var(--accent-pink);
        }

        .nav-link .icon-system {
            color: var(--accent-purple);
        }

        .nav-link .icon-team {
            color: var(--accent-blue);
        }

        .main-content {
            flex: 1;
            margin-{{ app()->getLocale() == 'ar' ? 'right' : 'left' }}: 280px;
            padding: 25px;
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        .top-navbar {
            background: var(--card-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 16px;
            padding: 15px 25px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .hamburger-btn {
            background: transparent;
            border: none;
            color: #94a3b8;
            font-size: 1.3rem;
            padding: 8px;
            cursor: pointer;
            display: none;
        }

        .user-section {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--gradient-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            color: #fff;
        }

        .user-info {
            text-align:
                {{ app()->getLocale() == 'ar' ? 'left' : 'right' }}
            ;
        }

        .user-name {
            font-weight: 600;
            color: #fff;
            font-size: 0.95rem;
        }

        .user-role {
            font-size: 0.75rem;
            color: #64748b;
        }

        .card {
            background: var(--card-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 16px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-3px);
            border-color: rgba(139, 92, 246, 0.3);
        }

        .card-header {
            background: rgba(0, 0, 0, 0.2);
            border-bottom: 1px solid var(--glass-border);
            padding: 18px 24px;
        }

        .card-body {
            padding: 24px;
        }

        .stat-card {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.05), rgba(255, 255, 255, 0.01));
            border: 1px solid var(--glass-border);
            border-radius: 16px;
            padding: 20px;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.3rem;
            margin-bottom: 15px;
        }

        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #fff;
        }

        .stat-label {
            color: #64748b;
            font-size: 0.85rem;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .stat-trend {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            font-size: 0.8rem;
            padding: 4px 10px;
            border-radius: 20px;
            margin-top: 10px;
        }

        .stat-trend.up {
            background: rgba(16, 185, 129, 0.15);
            color: var(--accent-green);
        }

        .stat-trend.down {
            background: rgba(239, 68, 68, 0.15);
            color: var(--accent-red);
        }

        .stat-card.cyan .stat-icon {
            background: rgba(0, 212, 255, 0.15);
            color: var(--accent-cyan);
        }

        .stat-card.purple .stat-icon {
            background: rgba(139, 92, 246, 0.15);
            color: var(--accent-purple);
        }

        .stat-card.green .stat-icon {
            background: rgba(16, 185, 129, 0.15);
            color: var(--accent-green);
        }

        .stat-card.orange .stat-icon {
            background: rgba(249, 115, 22, 0.15);
            color: var(--accent-orange);
        }

        .stat-card.pink .stat-icon {
            background: rgba(236, 72, 153, 0.15);
            color: var(--accent-pink);
        }

        .stat-card.yellow .stat-icon {
            background: rgba(251, 191, 36, 0.15);
            color: var(--accent-yellow);
        }

        .btn-primary {
            background: var(--gradient-primary);
            border: none;
            padding: 12px 24px;
            border-radius: 12px;
            font-weight: 600;
        }

        .form-control,
        .form-select {
            background: rgba(0, 0, 0, 0.3);
            border: 1px solid var(--glass-border);
            color: #e2e8f0;
            border-radius: 10px;
            padding: 12px 16px;
        }

        .form-control:focus,
        .form-select:focus {
            background: rgba(0, 0, 0, 0.4);
            border-color: var(--accent-purple);
            box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.15);
            color: #fff;
        }

        .form-label {
            color: #94a3b8;
            font-size: 0.85rem;
            font-weight: 500;
            text-transform: uppercase;
        }

        .table {
            color: #e2e8f0;
        }

        .table thead th {
            background: rgba(0, 0, 0, 0.3);
            border-bottom: 1px solid var(--glass-border);
            color: #94a3b8;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            padding: 15px 20px;
        }

        .table tbody td {
            padding: 15px 20px;
            border-bottom: 1px solid var(--glass-border);
        }

        .table tbody tr:hover {
            background: var(--glass-hover);
        }

        .alert {
            border-radius: 12px;
            border: none;
            padding: 16px 20px;
        }

        .alert-success {
            background: rgba(16, 185, 129, 0.15);
            color: var(--accent-green);
        }

        .alert-danger {
            background: rgba(239, 68, 68, 0.15);
            color: var(--accent-red);
        }

        .page-header {
            margin-bottom: 25px;
        }

        .page-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: #fff;
            margin-bottom: 5px;
        }

        .page-subtitle {
            color: #64748b;
            font-size: 0.9rem;
        }

        .logout-section {
            padding: 20px;
            border-top: 1px solid var(--glass-border);
            margin-top: 20px;
        }

        .btn-logout {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: var(--accent-red);
            border-radius: 12px;
            padding: 12px;
            width: 100%;
            font-weight: 600;
        }

        .btn-logout:hover {
            background: rgba(239, 68, 68, 0.2);
            color: #fff;
        }

        .glass-card {
            background: var(--card-bg) !important;
            backdrop-filter: blur(20px);
        }

        @media (max-width: 992px) {
            .sidebar.active {
                transform: translateX(0);
            }

            .sidebar:not(.active) {
                transform: translateX({{ app()->getLocale() == 'ar' ? '100%' : '-100%' }});
            }

            .main-content {
                margin-left: 0 !important;
                margin-right: 0 !important;
                padding: 15px;
                width: 100%;
            }

            .page-title {
                font-size: 1.4rem;
            }

            .breadcrumb {
                font-size: 0.8rem;
                margin-bottom: 5px;
            }

            .row {
                margin-left: -8px;
                margin-right: -8px;
            }

            .col,
            [class*="col-"] {
                padding-left: 8px;
                padding-right: 8px;
            }

            .hamburger-btn {
                display: block;
            }

            /* Tablet Top Navbar */
            .top-navbar {
                padding: 10px 15px;
            }

            /* Tablet Stat Cards - 2 per row */
            .stat-card {
                margin-bottom: 15px;
            }

            .stat-card .card-body {
                padding: 1rem;
            }

            .stat-card h3 {
                font-size: 1.5rem;
            }

            /* Tablet Tables - Keep table but adjust */
            .table th,
            .table td {
                padding: 0.6rem 0.5rem;
                font-size: 0.875rem;
            }

            /* Tablet Cards */
            .card {
                margin-bottom: 15px;
            }

            .card-body {
                padding: 1rem;
            }

            /* Tablet Action Buttons */
            .btn-group .btn {
                padding: 0.4rem 0.6rem;
            }

            /* Tablet Header Actions */
            .text-md-end {
                margin-top: 10px;
            }

            .text-md-end .btn {
                padding: 0.5rem 1rem;
                font-size: 0.875rem;
            }

            /* Tablet Glass Cards */
            .glass-card {
                border-radius: 16px;
            }

            /* Tablet Form Controls */
            .form-control,
            .form-select {
                font-size: 0.9rem;
                padding: 0.5rem 0.75rem;
            }

            /* Tablet Modal */
            .modal-dialog {
                max-width: 90%;
                margin: 1rem auto;
            }

            /* Tablet Tabs */
            .nav-tabs .nav-link {
                padding: 0.6rem 1rem;
                font-size: 0.875rem;
            }

            /* Tablet Search Bar */
            .glass-search {
                max-width: 100%;
            }

            .search-container {
                display: none !important;
            }

            /* Hide less important columns on tablet */
            .table .d-tablet-none {
                display: none !important;
            }

            /* Tablet Filter Badge Bar */
            .d-flex.flex-wrap.gap-2 .btn {
                padding: 0.35rem 0.75rem;
                font-size: 0.8rem;
            }
        }

        /* Tablet-specific (landscape tablets) */
        @media (min-width: 769px) and (max-width: 992px) {

            /* Show bottom nav on tablets too */
            .bottom-nav {
                display: flex;
            }

            .main-content {
                padding-bottom: 80px !important;
            }

            /* Tablet 2-column grid for stat-cards */
            .row.g-3>.col-6.col-lg-3 {
                flex: 0 0 50%;
                max-width: 50%;
            }

            /* Customer sidebar visible on tablet landscape */
            .col-md-3.d-none.d-md-block {
                display: block !important;
            }

            /* Adjust sidebar width on tablet */
            .col-md-3 {
                flex: 0 0 30%;
                max-width: 30%;
            }

            .col-md-9 {
                flex: 0 0 70%;
                max-width: 70%;
            }

            /* Table adjustments for tablet */
            .table-responsive-stack thead {
                display: table-header-group !important;
            }

            .table-responsive-stack tbody tr {
                display: table-row !important;
                margin-bottom: 0;
                background: transparent;
                border: none;
                padding: 0;
            }

            .table-responsive-stack tbody td {
                display: table-cell !important;
                border-bottom: 1px solid var(--glass-border) !important;
            }

            .table-responsive-stack tbody td::before {
                display: none;
            }
        }

        @media (max-width: 768px) {
            .top-navbar {
                padding: 12px 15px;
            }

            .user-info {
                display: none;
            }

            .main-content {
                padding-bottom: 80px !important;
                /* Space for bottom nav */
            }

            .bottom-nav {
                display: flex;
            }
        }

        /* Professional Mobile Table Stacking */
        @media (max-width: 768px) {
            .table-responsive-stack thead {
                display: none;
            }

            .table-responsive-stack tbody tr {
                display: block;
                margin-bottom: 1rem;
                background: rgba(30, 35, 45, 0.8);
                border-radius: 12px;
                border: 1px solid var(--glass-border);
                padding: 1rem;
            }

            .table-responsive-stack tbody td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 0.5rem 0;
                border: none !important;
                border-bottom: 1px solid rgba(255, 255, 255, 0.05) !important;
            }

            .table-responsive-stack tbody td:last-child {
                border-bottom: none !important;
            }

            .table-responsive-stack tbody td::before {
                content: attr(data-label);
                font-weight: 600;
                color: #94a3b8;
                font-size: 0.75rem;
                text-transform: uppercase;
                flex-shrink: 0;
                margin-right: auto;
                padding-right: 1rem;
            }

            .table-responsive-stack tbody td[data-label]::before {
                margin-left: 0 !important;
            }

            .table-responsive-stack tbody td .btn-group,
            .table-responsive-stack tbody td .text-end {
                text-align: right !important;
            }

            /* Improved Card Hover */
            .table-responsive-stack tbody tr:hover {
                background: rgba(40, 45, 55, 0.9);
                transform: translateY(-2px);
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
            }

            /* Enhanced stat cards on mobile */
            .stat-card .card-body {
                padding: 1rem !important;
            }

            .stat-card h3 {
                font-size: 1.25rem;
            }

            /* Form controls touch-friendly */
            .form-control,
            .form-select,
            .btn {
                min-height: 44px;
            }

            /* Modal full-screen on mobile */
            .modal-dialog {
                margin: 0;
                max-width: 100%;
                height: 100%;
            }

            .modal-content {
                height: 100%;
                border-radius: 0;
            }

            /* Tabs scrollable on mobile */
            .nav-tabs {
                flex-wrap: nowrap;
                overflow-x: auto;
                overflow-y: hidden;
                -webkit-overflow-scrolling: touch;
            }

            .nav-tabs .nav-link {
                white-space: nowrap;
            }

            /* Header action buttons */
            .col-md-6.text-md-end .btn {
                padding: 0.375rem 0.75rem;
                font-size: 0.875rem;
            }

            /* Glass cards enhanced touch */
            .glass-card {
                border-radius: 16px;
            }
        }

        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }

        .sidebar-overlay.active {
            display: block;
        }

        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: transparent;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--glass-border);
            border-radius: 3px;
        }

        /* Mobile Bottom Nav Styles */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            {{ app()->getLocale() == 'ar' ? 'right' : 'left' }}
            : 0;
            width: 100%;
            height: 70px;
            background: rgba(15, 19, 24, 0.9);
            backdrop-filter: blur(20px);
            border-top: 1px solid var(--glass-border);
            display: none;
            justify-content: space-around;
            align-items: center;
            z-index: 2000;
            padding-bottom: env(safe-area-inset-bottom);
        }

        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: #94a3b8;
            text-decoration: none;
            font-size: 0.7rem;
            transition: all 0.2s;
            flex: 1;
        }

        .bottom-nav-item i {
            font-size: 1.2rem;
            margin-bottom: 4px;
        }

        .bottom-nav-item.active {
            color: var(--accent-cyan);
        }

        /* App Menu (Bottom Sheet) */
        .app-menu-sheet {
            position: fixed;
            bottom: -100%;
            left: 0;
            width: 100%;
            background: rgba(15, 19, 24, 0.98);
            backdrop-filter: blur(30px);
            border-top: 1px solid var(--glass-border);
            border-radius: 30px 30px 0 0;
            z-index: 2100;
            transition: bottom 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            padding: 30px 20px 100px 20px;
        }

        .app-menu-sheet.active {
            bottom: 0;
        }

        .app-menu-header {
            width: 50px;
            height: 5px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 10px;
            margin: 0 auto 25px auto;
        }

        .app-menu-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .app-menu-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #fff;
            padding: 15px;
            border-radius: 20px;
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid var(--glass-border);
        }

        .app-menu-item i {
            font-size: 1.5rem;
            margin-bottom: 10px;
            background: linear-gradient(135deg, var(--accent-cyan), var(--accent-purple));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .app-menu-item span {
            font-size: 0.75rem;
            font-weight: 600;
            text-align: center;
        }

        .app-menu-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(5px);
            z-index: 2050;
            display: none;
        }

        .app-menu-overlay.active {
            display: block;
        }

        .bottom-nav-item.active i {
            color: var(--accent-purple);
            text-shadow: 0 0 10px rgba(139, 92, 246, 0.5);
        }

        /* Fixed Mobile Header */
        .mobile-header {
            position: sticky;
            top: 0;
            left: 0;
            width: 100%;
            height: 60px;
            background: rgba(15, 19, 24, 0.8);
            backdrop-filter: blur(15px);
            border-bottom: 1px solid var(--glass-border);
            display: none;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            z-index: 1040;
        }

        .mobile-header .brand {
            font-weight: 800;
            letter-spacing: 1px;
            font-size: 1.1rem;
            background: linear-gradient(135deg, var(--accent-cyan), var(--accent-purple));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* Responsive Table Cards */
        @media (max-width: 768px) {
            .table-responsive-stack .table thead {
                display: none;
            }

            .table-responsive-stack .table tbody td {
                display: block;
                width: 100%;
                text-align:
                    {{ app()->getLocale() == 'ar' ? 'right' : 'left' }}
                    !important;
                padding-{{ app()->getLocale() == 'ar' ? 'right' : 'left' }}: 45%;
                padding-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }}: 15px;
                position: relative;
                border-bottom: 1px solid var(--glass-border);
                min-height: 48px;
                display: flex;
                align-items: center;
                justify-content: flex-end;
            }

            .table-responsive-stack .table tbody td::before {
                content: attr(data-label);
                position: absolute;
                {{ app()->getLocale() == 'ar' ? 'right' : 'left' }}
                : 15px;
                width: 40%;
                font-weight: 700;
                text-align:
                    {{ app()->getLocale() == 'ar' ? 'right' : 'left' }}
                ;
                color: #64748b;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }
        }

        @media (max-width: 992px) {
            .bottom-nav {
                display: flex;
            }

            .mobile-header {
                display: flex;
            }

            .sidebar {
                width: 300px;
                height: 100%;
                z-index: 2100;
                /* Sidebar above bottom nav */
            }

            .main-content {
                padding-bottom: 100px;
            }

            .top-navbar {
                display: none;
            }

            /* Better Touch Targets */
            .btn,
            .nav-link,
            .bottom-nav-item {
                min-height: 48px;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            /* Component Density */
            .stat-card,
            .stat-card-premium {
                padding: 15px !important;
            }

            .stat-value,
            .stat-value-premium {
                font-size: 1.4rem !important;
            }

            .stat-label,
            .stat-label-premium {
                font-size: 0.75rem !important;
            }

            /* FAB Styles */
            .mobile-fab {
                position: fixed;
                {{ app()->getLocale() == 'ar' ? 'left' : 'right' }}
                : 20px;
                bottom: 90px;
                width: 56px;
                height: 56px;
                background: var(--gradient-primary);
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                color: #fff;
                box-shadow: 0 4px 15px rgba(118, 75, 162, 0.4);
                z-index: 1045;
                text-decoration: none;
                transition: transform 0.2s;
            }

            .mobile-fab:active {
                transform: scale(0.9);
            }
        }
    </style>

    @stack('styles')
</head>

<body>
    <div class="mobile-header">
        <button class="hamburger-btn" id="sidebarCollapseMobile">
            <i class="fas fa-bars"></i>
        </button>
        <div class="brand">SMARTONE</div>
        <div class="user-avatar" style="width: 32px; height: 32px; font-size: 0.8rem;">
            {{ strtoupper(substr(auth()->user()->name ?? 'U', 0, 1)) }}
        </div>
    </div>

    <div class="bottom-nav">
        <a href="{{ route('dashboard') }}"
            class="bottom-nav-item {{ request()->routeIs('dashboard') ? 'active' : '' }}">
            <i class="fas fa-th-large"></i>
            <span>{{ __('Dashboard') }}</span>
        </a>
        <a href="{{ route('customers.index') }}"
            class="bottom-nav-item {{ request()->routeIs('customers.*') ? 'active' : '' }}">
            <i class="fas fa-users"></i>
            <span>{{ __('CRM') }}</span>
        </a>
        <a href="{{ route('accounting.treasuries.index') }}"
            class="bottom-nav-item {{ request()->routeIs('accounting.treasuries.*') || request()->routeIs('accounting.bills.*') ? 'active' : '' }}">
            <i class="fas fa-wallet"></i>
            <span>{{ __('Finance') }}</span>
        </a>
        <a href="{{ route('accounting.projects.index') }}"
            class="bottom-nav-item {{ request()->routeIs('accounting.projects.*') ? 'active' : '' }}">
            <i class="fas fa-project-diagram"></i>
            <span>{{ __('Projects') }}</span>
        </a>
        <a href="javascript:void(0)" class="bottom-nav-item" id="openSidebar">
            <i class="fas fa-bars"></i>
            <span>{{ __('Menu') }}</span>
        </a>
    </div>

    <!-- App Menu Sheet -->
    <div class="app-menu-overlay" id="appMenuOverlay"></div>
    <!-- App Menu Sheet Removed/Hidden as per request for full sidebar -->

    @if(request()->routeIs('accounting.invoices.*'))
        <a href="{{ route('accounting.invoices.create') }}" class="mobile-fab d-lg-none">
            <i class="fas fa-plus fa-lg"></i>
        </a>
    @elseif(request()->routeIs('customers.*'))
        <a href="{{ route('customers.create') }}" class="mobile-fab d-lg-none">
            <i class="fas fa-user-plus fa-lg"></i>
        </a>
    @endif

    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="wrapper">
        <!-- Sidebar -->
        <nav class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <h3><i class="fas fa-bolt me-2"></i>SMARTONE</h3>
            </div>

            <div class="sidebar-content">
                <ul class="nav flex-column">
                    <!-- Dashboard -->
                    <li class="nav-item">
                        <a href="{{ route('dashboard') }}"
                            class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                            <i class="fas fa-th-large icon-system"></i>
                            {{ __('Dashboard') }}
                        </a>
                    </li>

                    {{-- ... (Sidebar items continue) ... --}}

                    @if(auth()->user()->hasRole('programmer') && !auth()->user()->hasRole('admin'))
                        <li class="nav-item">
                            <a href="{{ route('programmer.dashboard') }}"
                                class="nav-link {{ request()->routeIs('programmer.*') ? 'active' : '' }}">
                                <i class="fas fa-laptop-code text-info"></i>
                                {{ __('My Projects') }}
                            </a>
                        </li>
                    @endif

                    <!-- CRM & CUSTOMERS -->
                    @if(\App\Models\Setting::isModuleEnabled('module_crm'))
                        <li class="nav-header">{{ __('CRM & CUSTOMERS') }}</li>

                        @can('view customers')
                            <li class="nav-item">
                                <a href="{{ route('customers.index') }}"
                                    class="nav-link {{ request()->routeIs('customers.*') ? 'active' : '' }}">
                                    <i class="fas fa-users icon-crm"></i>
                                    {{ __('Customers') }}
                                </a>
                            </li>
                        @endcan

                        @can('view sales_team')
                            <li class="nav-item">
                                <a href="{{ route('accounting.sales-people.index') }}"
                                    class="nav-link {{ request()->routeIs('accounting.sales-people.*') ? 'active' : '' }}">
                                    <i class="fas fa-headset icon-crm"></i>
                                    {{ __('Sales Team') }}
                                </a>
                            </li>
                        @endcan

                        @can('view loyalty')
                            <li class="nav-item">
                                <a href="{{ route('loyalty.index') }}"
                                    class="nav-link {{ request()->routeIs('loyalty.*') ? 'active' : '' }}">
                                    <i class="fas fa-star icon-crm"></i>
                                    {{ __('Loyalty System') }}
                                </a>
                            </li>
                        @endcan

                        <li class="nav-item">
                            <a href="{{ route('accounting.tickets.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.tickets.*') ? 'active' : '' }}">
                                <i class="fas fa-ticket-alt icon-crm"></i>
                                {{ __('Support Tickets') }}
                            </a>
                        </li>
                    @endif

                    <!-- HR & PAYROLL -->
                    @if(\App\Models\Setting::isModuleEnabled('module_hr'))
                        @can('view employees')
                            <li class="nav-header">{{ __('HR & PAYROLL') }}</li>
                            <li class="nav-item">
                                <a href="{{ route('hr.employees.index') }}"
                                    class="nav-link {{ request()->routeIs('hr.employees.*') ? 'active' : '' }}">
                                    <i class="fas fa-users icon-crm"></i>
                                    {{ __('Employees') }}
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('hr.departments.index') }}"
                                    class="nav-link {{ request()->routeIs('hr.departments.*') ? 'active' : '' }}">
                                    <i class="fas fa-sitemap icon-crm"></i>
                                    {{ __('Departments') }}
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('hr.designations.index') }}"
                                    class="nav-link {{ request()->routeIs('hr.designations.*') ? 'active' : '' }}">
                                    <i class="fas fa-id-badge icon-crm"></i>
                                    {{ __('Designations') }}
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('hr.attendance.index') }}"
                                    class="nav-link {{ request()->routeIs('hr.attendance.*') ? 'active' : '' }}">
                                    <i class="fas fa-clock icon-crm"></i>
                                    {{ __('Attendance') }}
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('hr.payroll.index') }}"
                                    class="nav-link {{ request()->routeIs('hr.payroll.*') ? 'active' : '' }}">
                                    <i class="fas fa-money-check-alt icon-crm"></i>
                                    {{ __('Payroll') }}
                                </a>
                            </li>
                        @endcan
                    @endif

                    <!-- SUBSCRIPTIONS & SERVICES -->
                    @if(\App\Models\Setting::isModuleEnabled('module_subscriptions') || \App\Models\Setting::isModuleEnabled('module_inventory'))
                        <li class="nav-header">{{ __('Subscriptions & Services Management') }}</li>

                        @if(\App\Models\Setting::isModuleEnabled('module_inventory'))
                            @can('view products')
                                <li class="nav-item">
                                    <a href="{{ route('products.index') }}"
                                        class="nav-link {{ request()->routeIs('products.*') ? 'active' : '' }}">
                                        <i class="fas fa-boxes icon-procurement"></i>
                                        {{ __('Services & Products') }}
                                    </a>
                                </li>
                            @endcan
                        @elseif(\App\Models\Setting::isModuleEnabled('module_projects'))
                            <li class="nav-item">
                                <a href="{{ route('products.index') }}"
                                    class="nav-link {{ request()->routeIs('products.*') ? 'active' : '' }}">
                                    <i class="fas fa-cube icon-team"></i>
                                    {{ __('Services & Products') }}
                                </a>
                            </li>
                        @endif

                        @if(\App\Models\Setting::isModuleEnabled('module_subscriptions'))
                            <li class="nav-item">
                                <a href="{{ route('accounting.subscriptions.index') }}"
                                    class="nav-link {{ request()->routeIs('accounting.subscriptions.*') ? 'active' : '' }}">
                                    <i class="fas fa-calendar-check icon-team"></i>
                                    {{ __('Subscriptions') }}
                                </a>
                            </li>
                        @endif

                        <li class="nav-item">
                            <a href="{{ route('accounting.recurring.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.recurring.*') ? 'active' : '' }}">
                                <i class="fas fa-redo icon-finance"></i>
                                {{ __('Recurring Invoices') }}
                            </a>
                        </li>
                    @endif

                    <!-- PROJECTS & SERVICES -->
                    @if(\App\Models\Setting::isModuleEnabled('module_projects'))
                        <li class="nav-header">{{ __('PROJECTS & SERVICES') }}</li>
                        <li class="nav-item">
                            <a href="{{ route('accounting.projects.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.projects.*') ? 'active' : '' }}">
                                <i class="fas fa-diagram-project icon-team"></i>
                                {{ __('Projects') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('accounting.programmers.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.programmers.*') ? 'active' : '' }}">
                                <i class="fas fa-user-gear icon-team"></i>
                                {{ __('Programmers Management') }}
                            </a>
                        </li>
                    @endif

                    <!-- WAREHOUSES -->
                    @if(\App\Models\Setting::isModuleEnabled('module_inventory'))
                        @can('view warehouses')
                            <li class="nav-header">{{ __('INVENTORY & WAREHOUSES') }}</li>
                            <li class="nav-item">
                                <a href="{{ route('accounting.warehouses.index') }}"
                                    class="nav-link {{ request()->routeIs('accounting.warehouses.*') ? 'active' : '' }}">
                                    <i class="fas fa-warehouse icon-procurement"></i>
                                    {{ __('Warehouses') }}
                                </a>
                            </li>
                        @endcan
                    @endif

                    <!-- FINANCE -->
                    <li class="nav-header">{{ __('FINANCE') }}</li>

                    @if(\App\Models\Setting::isModuleEnabled('module_quotations'))
                        <li class="nav-item">
                            <a href="{{ route('accounting.quotations.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.quotations.*') ? 'active' : '' }}">
                                <i class="fas fa-file-contract icon-finance"></i>
                                {{ __('Quotations') }}
                            </a>
                        </li>
                    @endif

                    @can('view invoices')
                        <li class="nav-item">
                            <a href="{{ route('accounting.invoices.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.invoices.index') ? 'active' : '' }}">
                                <i class="fas fa-file-invoice-dollar icon-finance"></i>
                                {{ __('Sales Invoices') }}
                            </a>
                        </li>
                    @endcan

                    @if(\App\Models\Setting::isModuleEnabled('module_accounting'))
                        @can('view treasuries')
                            <li class="nav-item">
                                <a href="{{ route('accounting.treasuries.index') }}"
                                    class="nav-link {{ request()->routeIs('accounting.treasuries.*') ? 'active' : '' }}">
                                    <i class="fas fa-vault icon-finance"></i>
                                    {{ __('Safes & Bank Accounts') }}
                                </a>
                            </li>
                        @endcan

                        <li class="nav-item">
                            <a href="{{ route('accounting.transactions.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.transactions.*') ? 'active' : '' }}">
                                <i class="fas fa-list-alt icon-finance"></i>
                                {{ __('Financial Transactions Log') }}
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('accounting.bills.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.bills.*') ? 'active' : '' }}">
                                <i class="fas fa-file-invoice icon-procurement"></i>
                                {{ __('Purchase Bills') }}
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('accounting.expenses.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.expenses.*') ? 'active' : '' }}">
                                <i class="fas fa-receipt icon-procurement"></i>
                                {{ __('General Expenses') }}
                            </a>
                        </li>
                    @endif

                    <!-- PROCUREMENT -->
                    @if(\App\Models\Setting::isModuleEnabled('module_accounting'))
                        <li class="nav-header">{{ __('PROCUREMENT') }}</li>

                        <li class="nav-item">
                            <a href="{{ route('accounting.suppliers.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.suppliers.*') ? 'active' : '' }}">
                                <i class="fas fa-truck icon-procurement"></i>
                                {{ __('Suppliers') }}
                            </a>
                        </li>
                    @endif

                    <!-- INVESTMENTS -->
                    <li class="nav-header">{{ __('INVESTMENTS') }}</li>

                    <li class="nav-item">
                        <a href="{{ route('accounting.partners.index') }}"
                            class="nav-link {{ request()->routeIs('accounting.partners.*') ? 'active' : '' }}">
                            <i class="fas fa-handshake icon-invest"></i>
                            {{ __('Partners') }}
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('accounting.shares.index') }}"
                            class="nav-link {{ request()->routeIs('accounting.shares.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-pie icon-invest"></i>
                            {{ __('Shares Dashboard') }}
                        </a>
                    </li>

                    <!-- ANALYTICS -->
                    <li class="nav-header">{{ __('ANALYTICS') }}</li>

                    <li class="nav-item">
                        <a href="{{ route('accounting.reports.index') }}"
                            class="nav-link {{ request()->routeIs('accounting.reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-line icon-analytics"></i>
                            {{ __('Reports & Analytics') }}
                        </a>
                    </li>

                    @can('view settings')
                    @endcan

                    <!-- AI ASSISTANT -->
                    @if(\App\Models\Setting::isModuleEnabled('module_ai'))
                        <li class="nav-header">{{ __('AI ASSISTANT') }}</li>
                        <li class="nav-item">
                            <a href="#" class="nav-link text-muted">
                                <i class="fas fa-robot icon-system"></i>
                                {{ __('AI Dashboard') }} <span class="badge bg-info ms-2">{{ __('Coming Soon') }}</span>
                            </a>
                        </li>
                    @endif

                    <!-- SYSTEM -->
                    <li class="nav-header">{{ __('SYSTEM') }}</li>

                    <li class="nav-item">
                        <a href="{{ route('settings.whatsapp.index') }}"
                            class="nav-link {{ request()->routeIs('settings.whatsapp.*') ? 'active' : '' }}">
                            <i class="fab fa-whatsapp icon-system text-success"></i>
                            {{ __('WhatsApp Templates') }}
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('settings.updates.index') }}"
                            class="nav-link {{ request()->routeIs('settings.updates.*') ? 'active' : '' }}">
                            <i class="fas fa-sync-alt icon-system text-info"></i>
                            {{ __('System Updates') }}
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('settings.index') }}"
                            class="nav-link {{ request()->routeIs('settings.index') ? 'active' : '' }}">
                            <i class="fas fa-sliders-h icon-system"></i>
                            {{ __('General Settings') }}
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('settings.modules') }}"
                            class="nav-link {{ request()->routeIs('settings.modules') ? 'active' : '' }}">
                            <i class="fas fa-toggle-on icon-system"></i>
                            {{ __('Modules & Features') }}
                        </a>
                    </li>

                    @can('view whmcs')
                        <li class="nav-item">
                            <a href="{{ route('accounting.whmcs.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.whmcs.*') ? 'active' : '' }}">
                                <i class="fas fa-sync-alt icon-finance text-info"></i>
                                {{ __('WHMCS Sync') }}
                            </a>
                        </li>
                    @endcan

                    @can('view settings')
                        <li class="nav-item">
                            <a href="{{ route('units.index') }}"
                                class="nav-link {{ request()->routeIs('units.*') ? 'active' : '' }}">
                                <i class="fas fa-balance-scale icon-system"></i>
                                {{ __('Units & Measures') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('accounting.currencies.index') }}"
                                class="nav-link {{ request()->routeIs('accounting.currencies.*') ? 'active' : '' }}">
                                <i class="fas fa-coins icon-system"></i>
                                {{ __('Currencies') }}
                            </a>
                        </li>
                    @endcan

                    @if(auth()->user()->can('manage settings'))
                        <li class="nav-header">{{ __('USERS & PERMISSIONS') }}</li>
                        <li class="nav-item">
                            <a href="{{ route('settings.users.index') }}"
                                class="nav-link {{ request()->routeIs('settings.users.*') ? 'active' : '' }}">
                                <i class="fas fa-users-cog icon-system"></i>
                                {{ __('Users') }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('settings.roles.index') }}"
                                class="nav-link {{ request()->routeIs('settings.roles.*') ? 'active' : '' }}">
                                <i class="fas fa-user-shield icon-system"></i>
                                {{ __('Roles') }}
                            </a>
                        </li>
                    @endif
                </ul>

                <div class="logout-section">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="btn btn-logout">
                            <i class="fas fa-sign-out-alt me-2"></i>{{ __('Logout') }}
                        </button>
                    </form>
                </div>
            </div>
        </nav>

        <!-- Page Content -->
        <div class="main-content">
            <nav class="top-navbar">
                <button type="button" id="sidebarCollapse" class="hamburger-btn">
                    <i class="fas fa-bars"></i>
                </button>

                <!-- Search Bar -->
                <div class="search-container d-none d-md-block position-relative w-50">
                    <div class="input-group glass-search">
                        <select class="form-select border-0 bg-transparent text-muted" id="global-search-type"
                            style="max-width: 130px;">
                            <option value="all">{{ __('All') }}</option>
                            <option value="customers">{{ __('Customers') }}</option>
                            <option value="invoices">{{ __('Invoices') }}</option>
                            <option value="projects">{{ __('Projects') }}</option>
                            <option value="users">{{ __('Users') }}</option>
                        </select>
                        <span class="input-group-text border-0 bg-transparent"><i
                                class="fas fa-search text-muted"></i></span>
                        <input type="text" class="form-control border-0 bg-transparent text-white"
                            id="global-search-input" placeholder="{{ __('Search users, invoices, projects...') }}"
                            autocomplete="off">
                    </div>
                    <!-- Search Results Dropdown -->
                    <div id="global-search-results" class="position-absolute w-100 mt-2 glass-card d-none"
                        style="z-index: 1050; max-height: 400px; overflow-y: auto;">
                        <div class="text-center p-3 text-muted" id="search-loading">
                            <i class="fas fa-spinner fa-spin"></i> {{ __('Searching...') }}
                        </div>
                        <div id="search-results-content"></div>
                    </div>
                </div>

                <!-- Mobile Search Toggle -->
                <button class="btn btn-link text-white d-md-none" id="mobile-search-toggle">
                    <i class="fas fa-search"></i>
                </button>

                <div class="user-section">
                    <div class="user-info">
                        <div class="user-name">{{ Auth::user()->name ?? 'User' }}</div>
                        <div class="user-role">Administrator</div>
                    </div>
                    <div class="user-avatar">
                        {{ strtoupper(substr(Auth::user()->name ?? 'U', 0, 1)) }}
                    </div>
                </div>
            </nav>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @yield('content')
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function () {
            const sidebar = $('#sidebar');
            const overlay = $('#sidebarOverlay');

            function toggleSidebar() {
                sidebar.toggleClass('active');
                overlay.toggleClass('active');
            }

            // Bind all toggles
            $('#sidebarCollapse, #sidebarCollapseMobile, #openSidebar').on('click', function () {
                toggleSidebar();
            });

            // Close when clicking overlay
            overlay.on('click', function () {
                sidebar.removeClass('active');
                overlay.removeClass('active');
            });

            $(window).resize(function () {
                if ($(window).width() > 992) {
                    sidebar.removeClass('active');
                    overlay.removeClass('active');
                }
            });
        });
    </script>
    <!-- Custom Scripts -->
    <script src="{{ asset('js/global-search.js') }}"></script>
    @stack('scripts')
</body>

</html>