<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="dark">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Client Portal') }}</title>

    <!-- PWA Manifest & Theme -->
    <link rel="manifest" href="{{ asset('manifest.json') }}">
    <meta name="theme-color" content="#1e293b">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap & Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

    <style>
        :root {
            --primary-color: #6366f1;
            --secondary-color: #4f46e5;
            --background-dark: #0f172a;
            --surface-dark: #1e293b;
            --glass-bg: rgba(30, 41, 59, 0.7);
            --glass-border: rgba(255, 255, 255, 0.1);
        }

        body {
            font-family: 'Outfit', sans-serif;
            background-color: var(--background-dark);
            color: #e2e8f0;
            min-height: 100vh;
        }

        .navbar-portal {
            background: var(--surface-dark);
            border-bottom: 1px solid var(--glass-border);
            padding: 1rem 0;
        }

        .nav-link {
            color: #94a3b8;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .nav-link:hover,
        .nav-link.active {
            color: #fff;
            background: rgba(99, 102, 241, 0.1);
        }

        .portal-card {
            background: var(--surface-dark);
            border: 1px solid var(--glass-border);
            border-radius: 1rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }

        .stat-card {
            padding: 1.5rem;
            border-radius: 1rem;
            background: linear-gradient(145deg, var(--surface-dark), rgba(30, 41, 59, 0.8));
            border: 1px solid var(--glass-border);
        }

        .status-badge {
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            font-weight: 600;
            border-radius: 0.375rem;
        }
    </style>
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-portal">
        <div class="container">
            <a class="navbar-brand text-white fw-bold d-flex align-items-center" href="#">
                <i class="fas fa-bolt text-primary me-2"></i>
                SMARTONE PORTAL
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-lg-center">
                    <li class="nav-item">
                        <a href="{{ route('portal.index', request()->route('token')) }}"
                            class="nav-link {{ request()->routeIs('portal.index') ? 'active' : '' }} px-3">
                            {{ __('Dashboard') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('portal.services', request()->route('token')) }}"
                            class="nav-link {{ request()->routeIs('portal.services') ? 'active' : '' }} px-3">
                            {{ __('Services') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('portal.invoices', request()->route('token')) }}"
                            class="nav-link {{ request()->routeIs('portal.invoices') ? 'active' : '' }} px-3">
                            {{ __('Invoices') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('portal.quotations', request()->route('token')) }}"
                            class="nav-link {{ request()->routeIs('portal.quotations') ? 'active' : '' }} px-3">
                            {{ __('Quotations') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('portal.tickets.index', request()->route('token')) }}"
                            class="nav-link {{ request()->routeIs('portal.tickets.*') ? 'active' : '' }} px-3">
                            {{ __('Support Tickets') }}
                        </a>
                    </li>
                </ul>

                <div class="d-flex align-items-center text-muted small ms-lg-4 mt-3 mt-lg-0 px-3">
                    <i class="fas fa-user-circle me-2 fa-lg"></i>
                    @if(isset($customer))
                        {{ $customer->name }}
                    @else
                        {{ __('Guest') }}
                    @endif
                </div>
            </div>
        </div>
    </nav>

    <div class="container py-5">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @yield('content')
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/sw.js')
                    .then(registration => {
                        console.log('ServiceWorker registration successful with scope: ', registration.scope);
                    })
                    .catch(err => {
                        console.log('ServiceWorker registration failed: ', err);
                    });
            });
        }
    </script>
</body>

</html>