<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title')</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #fff;
            color: #333;
            direction: rtl;
        }

        .page-container {
            width: 210mm;
            min-height: 297mm;
            padding: 10mm;
            /* Reduced from 15mm */
            margin: auto;
            position: relative;
            box-sizing: border-box;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }

        .company-logo {
            max-height: 60px;
            /* Reduced from 80px */
        }

        .company-info {
            text-align: left;
            font-size: 11px;
            /* Reduced from 12px */
        }

        .document-title {
            text-align: center;
            margin: 10px 0;
            /* Reduced from 20px */
            font-size: 22px;
            font-weight: bold;
            text-decoration: underline;
        }

        .doc-meta {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            /* Reduced from 20px */
            background: #f8f9fa;
            padding: 8px;
            /* Reduced from 10px */
            border: 1px solid #ddd;
            font-size: 13px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            /* Reduced from 20px */
            font-size: 13px;
        }

        .table th,
        .table td {
            border: 1px solid #ddd;
            padding: 8px;
            /* Reduced from 12px */
            text-align: center;
        }

        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .totals-section {
            margin-top: 20px;
            /* Reduced from 30px */
            float: left;
            width: 300px;
            font-size: 13px;
        }

        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-table td {
            padding: 6px;
            /* Reduced from 8px */
            border-bottom: 1px solid #eee;
        }

        .totals-table .total-row {
            font-weight: bold;
            font-size: 16px;
            /* Reduced from 18px */
            border-top: 2px solid #000;
        }

        .signature-section {
            margin-top: 50px;
            /* Reduced from 100px */
            display: flex;
            justify-content: space-between;
        }

        .signature-box {
            text-align: center;
            width: 200px;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin-top: 30px;
            /* Reduced from 40px */
        }

        footer {
            position: absolute;
            bottom: 10mm;
            /* Reduced from 15mm */
            left: 10mm;
            right: 10mm;
            border-top: 1px solid #ddd;
            padding-top: 5px;
            font-size: 9px;
            text-align: center;
            color: #777;
        }

        @media print {
            @page {
                size: A4;
                margin: 0;
            }

            body {
                background: none;
                margin: 0;
            }

            .page-container {
                margin: 0;
                border: none;
                box-shadow: none;
                width: 210mm;
                height: 296mm;
                /* Explicit height slightly less than 297mm to be safe */
                padding: 10mm;
                overflow: hidden;
                /* Prevent spillover */
            }

            .no-print {
                display: none;
            }

            footer {
                bottom: 15mm;
                /* Move up slightly to avoid edge cutting */
                left: 10mm;
                right: 10mm;
            }
        }
    </style>
</head>

<body>
    <div class="no-print" style="text-align: center; padding: 10px; background: #eee;">
        <button onclick="window.print()">{{ __('اضغط للطباعة') }}</button>
    </div>

    <div class="page-container">
        <header>
            <div class="company-logo-box">
                @if($settings['company_logo'] ?? false)
                    <img src="{{ asset('storage/' . $settings['company_logo']) }}" class="company-logo">
                @else
                    <h2 style="margin:0;">{{ $settings['company_name'] ?? 'SmartOne Group' }}</h2>
                @endif
            </div>
            <div class="company-info">
                <strong>{{ $settings['company_name'] ?? '' }}</strong><br>
                {{ $settings['company_address'] ?? '' }}<br>
                {{ __('Tel:') }} {{ $settings['company_phone'] ?? '' }}<br>
                {{ __('Email:') }} {{ $settings['company_email'] ?? '' }}<br>
                {{ __('Tax ID:') }} {{ $settings['company_tax_id'] ?? '' }}
            </div>
        </header>

        <div class="document-title">
            @yield('doc_title')
        </div>

        @yield('content')

        <footer>
            {{ $settings['company_name'] ?? 'SmartOne Group' }} -
            {{ $settings['company_website'] ?? 'www.smartonegroup.com' }}
            <br>
            <br>
            {{ __('صفحة 1 من 1') }}
        </footer>
    </div>
</body>

</html>