@extends('layouts.app')

@section('content')
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title">{{ __('Loyalty System Dashboard') }}</h1>
            <p class="page-subtitle">{{ __('Track Points and Customer Engagement') }}</p>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="stat-card green h-100">
                <div class="stat-icon"><i class="fas fa-gift"></i></div>
                <div class="stat-value">{{ number_format($totalEarned, 0) }} <small class="fs-6 text-muted">Pts</small>
                </div>
                <div class="stat-label">{{ __('Total Points Earned') }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card orange h-100">
                <div class="stat-icon"><i class="fas fa-ticket-alt"></i></div>
                <div class="stat-value">{{ number_format($totalRedeemed, 0) }} <small class="fs-6 text-muted">Pts</small>
                </div>
                <div class="stat-label">{{ __('Total Points Redeemed') }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card pink h-100"> <!-- Pink for Liability/Balance -->
                <div class="stat-icon"><i class="fas fa-wallet"></i></div>
                <div class="stat-value">{{ number_format($totalLiability, 0) }} <small class="fs-6 text-muted">Pts</small>
                </div>
                <div class="stat-label">{{ __('Outstanding Liability') }}</div>
                <div class="stat-trend down text-white-50 mt-1">
                    {{ __('Active Points Held by Customers') }}
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card glass-card mb-4">
        <div class="card-body">
            <form action="{{ route('loyalty.index') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">{{ __('Customer') }}</label>
                    <select name="customer_id" class="form-select">
                        <option value="">{{ __('All Customers') }}</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                {{ $customer->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">{{ __('Transaction Type') }}</label>
                    <select name="type" class="form-select">
                        <option value="">{{ __('All Types') }}</option>
                        <option value="earned" {{ request('type') == 'earned' ? 'selected' : '' }}>{{ __('Earned') }}</option>
                        <option value="redeemed" {{ request('type') == 'redeemed' ? 'selected' : '' }}>{{ __('Redeemed') }}
                        </option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date From') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date To') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-2 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary w-100"><i
                            class="fas fa-filter me-2"></i>{{ __('Filter') }}</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="card glass-card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-history me-2"></i>{{ __('Points Log') }}</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th>{{ __('Date') }}</th>
                        <th>{{ __('Customer') }}</th>
                        <th>{{ __('Type') }}</th>
                        <th>{{ __('Points') }}</th>
                        <th>{{ __('Reference') }}</th>
                        <th>{{ __('Description') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($transactions as $transaction)
                        <tr>
                            <td>{{ $transaction->date->format('Y-m-d H:i') }}</td>
                            <td>
                                @if($transaction->customer)
                                    <a href="{{ route('customers.show', $transaction->customer) }}"
                                        class="text-white text-decoration-none">
                                        {{ $transaction->customer->name }}
                                    </a>
                                @else
                                    <span class="text-muted">{{ __('Unknown') }}</span>
                                @endif
                            </td>
                            <td>
                                @if($transaction->type == 'earned')
                                    <span class="badge bg-success">{{ __('Earned') }}</span>
                                @elseif($transaction->type == 'redeemed')
                                    <span class="badge bg-danger">{{ __('Redeemed') }}</span>
                                @else
                                    <span class="badge bg-secondary">{{ ucfirst($transaction->type) }}</span>
                                @endif
                            </td>
                            <td class="{{ $transaction->points > 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                {{ $transaction->points > 0 ? '+' : '' }}{{ number_format($transaction->points, 0) }}
                            </td>
                            <td>
                                @if($transaction->reference_type == 'App\Models\Invoice' && $transaction->reference_id)
                                    <a href="{{ route('accounting.invoices.show', $transaction->reference_id) }}"
                                        class="badge bg-primary text-decoration-none">
                                        <i class="fas fa-file-invoice me-1"></i>#{{ $transaction->reference_id }}
                                    </a>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>{{ $transaction->description }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-5 text-muted">
                                <i class="fas fa-box-open fa-3x mb-3"></i>
                                <p>{{ __('No transactions found.') }}</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer bg-transparent border-0 d-flex justify-content-end">
            {{ $transactions->links() }}
        </div>
    </div>
@endsection