@extends('layouts.portal')

@section('content')
    <div class="row g-4">
        <!-- Welcome Section -->
        <div class="col-12">
            <h1 class="display-6 fw-bold">{{ __('Welcome back') }}, {{ explode(' ', $customer->name)[0] }}!</h1>
            <p class="text-muted">{{ __("Here's what's happening with your account today.") }}</p>
        </div>

        <!-- Stats Cards -->
        <div class="col-6 col-md-3">
            <div class="stat-card h-100">
                <div class="d-flex align-items-center mb-3">
                    <div class="bg-primary bg-opacity-10 p-2 p-md-3 rounded-circle me-2 me-md-3">
                        <i class="fas fa-cubes text-primary fa-lg fa-md-xl"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-0 small">{{ __('Active Services') }}</h6>
                </div>
                <h2 class="fw-bold mb-0">{{ $activeServices }}</h2>
            </div>
        </div>

        <div class="col-6 col-md-3">
            <div class="stat-card h-100">
                <div class="d-flex align-items-center mb-3">
                    <div class="bg-danger bg-opacity-10 p-2 p-md-3 rounded-circle me-2 me-md-3">
                        <i class="fas fa-exclamation-circle text-danger fa-lg fa-md-xl"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-0 small">{{ __('Total Debt') }}</h6>
                </div>
                <h2 class="fw-bold mb-0 text-danger">{{ number_format($customer->total_debt, 2) }}</h2>
                <small class="text-muted small">{{ __('Outstanding') }}</small>
            </div>
        </div>

        <div class="col-6 col-md-3">
            <div class="stat-card h-100">
                <div class="d-flex align-items-center mb-3">
                    <div class="bg-success bg-opacity-10 p-2 p-md-3 rounded-circle me-2 me-md-3">
                        <i class="fas fa-wallet text-success fa-lg fa-md-xl"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-0 small">{{ __('Wallet Balance') }}</h6>
                </div>
                <h2 class="fw-bold mb-0 text-success">{{ number_format($customer->wallet_balance, 2) }}</h2>
                <small class="text-muted small">{{ __('Available Credit') }}</small>
            </div>
        </div>

        <div class="col-6 col-md-3">
            <div class="stat-card h-100">
                <div class="d-flex align-items-center mb-3">
                    <div class="bg-info bg-opacity-10 p-2 p-md-3 rounded-circle me-2 me-md-3">
                        <i class="fas fa-check-circle text-info fa-lg fa-md-xl"></i>
                    </div>
                    <h6 class="text-muted text-uppercase mb-0 small">{{ __('Paid Invoices') }}</h6>
                </div>
                <h2 class="fw-bold mb-0 text-info">{{ $paidInvoices }}</h2>
            </div>
        </div>

        <!-- Main Content Grid -->
        <div class="col-lg-8">
            <div class="portal-card h-100">
                <div
                    class="card-header bg-transparent border-secondary p-4 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">{{ __('Active Subscriptions') }}</h5>
                    <a href="{{ route('portal.services', $token) }}"
                        class="btn btn-sm btn-outline-primary">{{ __('View All') }}</a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover table-dark align-middle mb-0">
                            <thead class="bg-transparent text-muted small text-uppercase">
                                <tr>
                                    <th class="ps-4">{{ __('Service') }}</th>
                                    <th>{{ __('Cycle') }}</th>
                                    <th>{{ __('Next Due') }}</th>
                                    <th>{{ __('Status') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($subscriptions as $sub)
                                    <tr>
                                        <td class="ps-4 fw-bold">{{ $sub->service_name }}</td>
                                        <td>{{ __($sub->billing_cycle) }}</td>
                                        <td>
                                            @if($sub->next_due_date)
                                                <span class="{{ $sub->next_due_date->isPast() ? 'text-danger' : 'text-success' }}">
                                                    {{ $sub->next_due_date->format('M d, Y') }}
                                                </span>
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td>
                                            <span class="status-badge bg-success bg-opacity-20 text-success">
                                                {{ __('Active') }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center py-4 text-muted">{{ __('No active subscriptions.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="portal-card h-100">
                <div
                    class="card-header bg-transparent border-secondary p-4 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">{{ __('Recent Invoices') }}</h5>
                    <a href="{{ route('portal.invoices', $token) }}"
                        class="btn btn-sm btn-outline-primary">{{ __('View All') }}</a>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush rounded-bottom">
                        @forelse($recentInvoices as $invoice)
                            <div
                                class="list-group-item bg-transparent border-secondary d-flex justify-content-between align-items-center p-3">
                                <div>
                                    <div class="fw-bold">#{{ $invoice->code }}</div>
                                    <small class="text-muted">{{ $invoice->date->format('M d') }}</small>
                                </div>
                                <div class="text-end">
                                    <div class="fw-bold">{{ number_format($invoice->total, 2) }}</div>
                                    @if($invoice->status == 'paid')
                                        <span class="badge bg-success">{{ __('Paid') }}</span>
                                    @elseif($invoice->status == 'unpaid')
                                        <span class="badge bg-danger">{{ __('Unpaid') }}</span>
                                    @else
                                        <span class="badge bg-warning text-dark">{{ __('Partial') }}</span>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="p-4 text-center text-muted">{{ __('No recent invoices.') }}</div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection