@extends('layouts.portal')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-1">
                    <li class="breadcrumb-item"><a href="{{ route('portal.index', $token) }}"
                            class="text-decoration-none">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Invoices') }}</li>
                </ol>
            </nav>
            <h2 class="fw-bold">{{ __('My Invoices') }}</h2>
        </div>
    </div>

    <div class="portal-card">
        <div class="table-responsive">
            <table class="table table-hover table-dark align-middle mb-0">
                <thead>
                    <tr>
                        <th class="ps-4">{{ __('Invoice #') }}</th>
                        <th>{{ __('Date') }}</th>
                        <th>{{ __('Amount') }}</th>
                        <th>{{ __('Paid') }}</th>
                        <th>{{ __('Remaining') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th class="text-end pe-4">{{ __('Action') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                        <tr>
                            <td class="ps-4 fw-bold">
                                #{{ $invoice->code }}
                            </td>
                            <td>{{ $invoice->date->format('M d, Y') }}</td>
                            <td>{{ number_format($invoice->total, 2) }}</td>
                            <td class="text-success">{{ number_format($invoice->paid, 2) }}</td>
                            <td class="text-danger fw-bold">{{ number_format($invoice->remaining_balance, 2) }}</td>
                            <td>
                                @if($invoice->status == 'paid')
                                    <span class="status-badge bg-success bg-opacity-20 text-success">{{ __('Paid') }}</span>
                                @elseif($invoice->status == 'unpaid')
                                    <span class="status-badge bg-danger bg-opacity-20 text-danger">{{ __('Unpaid') }}</span>
                                @else
                                    <span class="status-badge bg-warning bg-opacity-20 text-warning">{{ __('Partial') }}</span>
                                @endif
                            </td>
                            <td class="text-end pe-4">
                                <!-- Assuming print route available, potentially restricted for guest auth -->
                                <!-- We can redirect to a public print route if implemented, or simple show details -->
                                <button class="btn btn-sm btn-outline-light">
                                    <i class="fas fa-download"></i>
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-5 text-muted">{{ __('No invoices found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-3">
            {{ $invoices->links() }}
        </div>
    </div>
@endsection
@endsection