@extends('layouts.portal')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">{{ __('My Quotations') }}</h3>
    </div>

    <div class="card bg-dark border-secondary">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dark table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Total') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($quotations as $quotation)
                            <tr>
                                <td>{{ $quotation->quotation_number ?? $quotation->id }}</td>
                                <td>{{ $quotation->date ? $quotation->date->format('Y-m-d') : '-' }}</td>
                                <td>{{ number_format($quotation->total, 2) }} {{ $quotation->currency->code ?? 'EGP' }}</td>
                                <td>
                                    @php
                                        $statusKey = $quotation->status ?? 'draft';
                                        $statusColor = match ($statusKey) {
                                            'accepted' => 'success',
                                            'rejected' => 'danger',
                                            'sent' => 'info',
                                            default => 'secondary'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $statusColor }}">{{ ucfirst(__($statusKey)) }}</span>
                                </td>
                                <td class="text-end">
                                    <a href="{{ route('accounting.quotations.print', $quotation) }}" target="_blank"
                                        class="btn btn-sm btn-outline-light">
                                        <i class="fas fa-file-pdf me-1"></i> {{ __('View PDF') }}
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-4 text-muted">
                                    <i class="fas fa-file-invoice fa-3x mb-3 d-block"></i>
                                    {{ __('No quotations found.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                {{ $quotations->links() }}
            </div>
        </div>
    </div>
@endsection