@extends('layouts.portal')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-1">
                    <li class="breadcrumb-item"><a href="{{ route('portal.index', $token) }}"
                            class="text-decoration-none">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Services') }}</li>
                </ol>
            </nav>
            <h2 class="fw-bold">{{ __('My Services & Subscriptions') }}</h2>
        </div>
    </div>

    <div class="portal-card">
        <div class="table-responsive">
            <table class="table table-hover table-dark align-middle mb-0">
                <thead>
                    <tr>
                        <th class="ps-4">{{ __('Service Name') }}</th>
                        <th>{{ __('Price') }}</th>
                        <th>{{ __('Cycle') }}</th>
                        <th>{{ __('Start Date') }}</th>
                        <th>{{ __('Next Renewal') }}</th>
                        <th>{{ __('Status') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subscriptions as $sub)
                        <tr>
                            <td class="ps-4">
                                <div class="fw-bold">{{ $sub->service_name }}</div>
                                <small class="text-muted">{{ __('ID') }}: {{ $sub->id }}</small>
                            </td>
                            <td>{{ number_format($sub->price, 2) }} {{ $sub->currency }}</td>
                            <td>{{ __($sub->billing_cycle) }}</td>
                            <td>{{ $sub->start_date ? $sub->start_date->format('M d, Y') : '-' }}</td>
                            <td>
                                @if($sub->next_due_date)
                                    <span class="{{ $sub->next_due_date->isPast() ? 'text-danger' : 'text-success' }} fw-bold">
                                        {{ $sub->next_due_date->format('Y-m-d') }}
                                    </span>
                                    @if($sub->next_due_date->isPast())
                                        <i class="fas fa-exclamation-triangle text-danger ms-1" title="{{ __('Overdue') }}"></i>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                @php
                                    $statusClass = match ($sub->status) {
                                        'active' => 'success',
                                        'suspended' => 'warning',
                                        'cancelled' => 'danger',
                                        default => 'secondary'
                                    };
                                @endphp
                                <span class="status-badge bg-{{ $statusClass }} bg-opacity-20 text-{{ $statusClass }}">
                                    {{ ucfirst(__($sub->status)) }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-5 text-muted">{{ __('No active services found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-3">
            {{ $subscriptions->links() }}
        </div>
    </div>
@endsection