@extends('layouts.portal')

@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="d-flex align-items-center mb-4">
                <a href="{{ route('portal.tickets.index', $token) }}" class="btn btn-outline-secondary me-3">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h3 class="fw-bold mb-0">{{ __('Open New Ticket') }}</h3>
            </div>

            <div class="portal-card p-4">
                <form action="{{ route('portal.tickets.store', $token) }}" method="POST">
                    @csrf

                    <div class="mb-3">
                        <label class="form-label text-muted">{{ __('Subject') }}</label>
                        <input type="text" name="subject" class="form-control bg-black text-white border-secondary"
                            required>
                    </div>

                    <div class="row g-3 mb-3">
                        <div class="col-md-6">
                            <label class="form-label text-muted">{{ __('Department') }}</label>
                            <select name="department_id" class="form-select bg-black text-white border-secondary" required>
                                <option value="1">{{ __('Support') }}</option>
                                <option value="2">{{ __('Sales') }}</option>
                                <option value="3">{{ __('Billing') }}</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label text-muted">{{ __('Priority') }}</label>
                            <select name="priority" class="form-select bg-black text-white border-secondary" required>
                                <option value="Low">{{ __('Low') }}</option>
                                <option value="Medium" selected>{{ __('Medium') }}</option>
                                <option value="High">{{ __('High') }}</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label text-muted">{{ __('Message') }}</label>
                        <textarea name="message" rows="6" class="form-control bg-black text-white border-secondary"
                            required></textarea>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary py-2">
                            <i class="fas fa-paper-plane me-2"></i> {{ __('Submit Ticket') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection