@extends('layouts.portal')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">{{ __('Support Tickets') }}</h3>
        <a href="{{ route('portal.tickets.create', $token) }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i> {{ __('Open New Ticket') }}
        </a>
    </div>

    <div class="portal-card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-dark align-middle mb-0">
                    <thead class="bg-transparent text-muted small text-uppercase">
                        <tr>
                            <th class="ps-4">{{ __('Ticket #') }}</th>
                            <th>{{ __('Subject') }}</th>
                            <th>{{ __('Department') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Last Update') }}</th>
                            <th class="text-end pe-4">{{ __('Action') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tickets as $ticket)
                            <tr>
                                <td class="ps-4 fw-bold">#{{ $ticket->whmcs_id }}</td>
                                <td>{{ $ticket->subject }}</td>
                                <td>{{ $ticket->department }}</td>
                                <td>
                                    @php
                                        $statusColor = match (strtolower($ticket->status)) {
                                            'open' => 'success',
                                            'answered' => 'warning',
                                            'customer-reply' => 'info',
                                            'closed' => 'secondary',
                                            default => 'primary'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $statusColor }} bg-opacity-20 text-{{ $statusColor }}">
                                        {{ __($ticket->status) }}
                                    </span>
                                </td>
                                <td>{{ $ticket->updated_at->diffForHumans() }}</td>
                                <td class="text-end pe-4">
                                    <a href="{{ route('portal.tickets.show', ['token' => $token, 'ticket' => $ticket->id]) }}"
                                        class="btn btn-sm btn-outline-light">
                                        {{ __('View') }}
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    <i class="fas fa-ticket-alt fa-2x mb-3 d-block opacity-50"></i>
                                    {{ __('No support tickets found.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($tickets->hasPages())
            <div class="card-footer bg-transparent border-top border-secondary p-3">
                {{ $tickets->links() }}
            </div>
        @endif
    </div>
@endsection