@extends('layouts.portal')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="d-flex align-items-center mb-4">
                <a href="{{ route('portal.tickets.index', $token) }}" class="btn btn-outline-secondary me-3">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <div>
                    <h3 class="fw-bold mb-1">#{{ $ticket->whmcs_id }} - {{ $ticket->subject }}</h3>
                    <span class="badge bg-secondary">{{ $ticket->department }}</span>
                    <span
                        class="badge bg-{{ $ticket->status == 'Closed' ? 'secondary' : 'success' }} ms-1">{{ __($ticket->status) }}</span>
                </div>
            </div>

            <div class="portal-card mb-4">
                <div class="card-body p-4" style="max-height: 600px; overflow-y: auto;">
                    @foreach($replies as $reply)
                        <div
                            class="mb-4 d-flex {{ !empty($reply['admin']) ? 'justify-content-start' : 'justify-content-end' }}">
                            <div class="p-3 rounded-3 {{ !empty($reply['admin']) ? 'bg-secondary bg-opacity-25' : 'bg-primary bg-opacity-25' }}"
                                style="max-width: 85%;">
                                <div class="d-flex justify-content-between align-items-center mb-2 small text-muted">
                                    <span class="fw-bold {{ !empty($reply['admin']) ? 'text-warning' : 'text-primary' }}">
                                        {{ $reply['requestorname'] ?: ($reply['admin'] ?? 'Agent') }}
                                    </span>
                                    <span class="ms-3">{{ $reply['date'] }}</span>
                                </div>
                                <div class="text-break">
                                    {!! nl2br(e($reply['message'])) !!}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if(strtolower($ticket->status) !== 'closed')
                    <div class="card-footer bg-transparent border-top border-secondary p-4">
                        <form action="{{ route('portal.tickets.reply', ['token' => $token, 'ticket' => $ticket->id]) }}"
                            method="POST">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label text-muted">{{ __('Reply') }}</label>
                                <textarea name="message" rows="4" class="form-control bg-black text-white border-secondary"
                                    placeholder="{{ __('Type your reply here...') }}" required></textarea>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-reply me-2"></i> {{ __('Send Reply') }}
                                </button>
                            </div>
                        </form>
                    </div>
                @else
                    <div class="card-footer bg-transparent border-top border-secondary p-4 text-center text-muted">
                        {{ __('This ticket is closed.') }}
                    </div>
                @endif
            </div>
        </div>

        <div class="col-md-4">
            <div class="portal-card p-4">
                <h5 class="fw-bold mb-3">{{ __('Ticket Info') }}</h5>
                <ul class="list-unstyled mb-0 text-muted">
                    <li class="mb-2 d-flex justify-content-between">
                        <span>{{ __('Created') }}:</span>
                        <span class="text-white">{{ $ticket->created_at->format('M d, Y') }}</span>
                    </li>
                    <li class="mb-2 d-flex justify-content-between">
                        <span>{{ __('Last Update') }}:</span>
                        <span class="text-white">{{ $ticket->updated_at->diffForHumans() }}</span>
                    </li>
                    <li class="mb-2 d-flex justify-content-between">
                        <span>{{ __('Priority') }}:</span>
                        <span
                            class="text-{{ match ($ticket->priority) { 'High' => 'danger', 'Medium' => 'warning', default => 'success'} }}">
                            {{ __($ticket->priority) }}
                        </span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
@endsection