@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('New Product / Service') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('products.index') }}">{{ __('Products') }}</a></li>
                    <li class="breadcrumb-item active">{{ __('Create') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('products.store') }}" method="POST">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">{{ __('Name') }} <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control"
                                placeholder="{{ __('e.g. Web Hosting, iPhone 13') }}" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ __('Type') }} <span class="text-danger">*</span></label>
                            <select name="type" class="form-select" required>
                                <option value="service">{{ __('Service (No Inventory)') }}</option>
                                <option value="physical">{{ __('Physical Product') }}</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ __('Unit') }}</label>
                            <select name="unit_id" class="form-select">
                                <option value="">{{ __('None') }}</option>
                                @foreach($units as $unit)
                                    <option value="{{ $unit->id }}">{{ $unit->name }} ({{ $unit->short_name }})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ __('SKU (Optional)') }}</label>
                            <input type="text" name="sku" class="form-control" placeholder="{{ __('e.g. SRV-001') }}">
                        </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Price (EGP)') }} <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text">EGP</span>
                            <input type="number" step="0.01" name="price" class="form-control" value="0.00" required>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Price (USD)') }}</label>
                        <div class="input-group">
                            <span class="input-group-text">USD</span>
                            <input type="number" step="0.01" name="price_usd" class="form-control" value="0.00">
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">{{ __('Description') }}</label>
                    <textarea name="description" class="form-control" rows="3"></textarea>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary">{{ __('Create Product') }}</button>
                    <a href="{{ route('products.index') }}" class="btn btn-outline-secondary">{{ __('Cancel') }}</a>
                </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection