@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Edit Product') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('products.index') }}">{{ __('Products') }}</a></li>
                    <li class="breadcrumb-item active">{{ $product->name }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('products.update', $product) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label class="form-label">{{ __('Name') }} <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ $product->name }}" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ __('Type') }} <span class="text-danger">*</span></label>
                            <select name="type" class="form-select" required>
                                <option value="service" {{ $product->type == 'service' ? 'selected' : '' }}>
                                    {{ __('Service (No Inventory)') }}
                                </option>
                                <option value="physical" {{ $product->type == 'physical' ? 'selected' : '' }}>
                                    {{ __('Physical Product') }}
                                </option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ __('Unit') }}</label>
                            <select name="unit_id" class="form-select">
                                <option value="">{{ __('None') }}</option>
                                @foreach($units as $unit)
                                    <option value="{{ $unit->id }}" {{ $product->unit_id == $unit->id ? 'selected' : '' }}>
                                        {{ $unit->name }} ({{ $unit->short_name }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ __('SKU (Optional)') }}</label>
                            <input type="text" name="sku" class="form-control" value="{{ $product->sku }}">
                        </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Price (EGP)') }} <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text">EGP</span>
                            <input type="number" step="0.01" name="price" class="form-control" value="{{ $product->price }}"
                                required>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">{{ __('Price (USD)') }}</label>
                        <div class="input-group">
                            <span class="input-group-text">USD</span>
                            <input type="number" step="0.01" name="price_usd" class="form-control"
                                value="{{ $product->price_usd }}">
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">{{ __('Description') }}</label>
                    <textarea name="description" class="form-control" rows="3">{{ $product->description }}</textarea>
                </div>

                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                    <a href="{{ route('products.index') }}" class="btn btn-outline-secondary">{{ __('Cancel') }}</a>
                </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection