@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <!-- Welcome Header -->
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light mb-1">{{ __('Welcome') }}, {{ $programmer->name }}</h2>
            <p class="text-muted">{{ __('Your projects and earnings overview') }}</p>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-project-diagram text-primary fa-lg"></i>
                        </div>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['total_projects'] }}</h3>
                    <small class="text-muted">{{ __('Total Projects') }}</small>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="bg-info bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-spinner text-info fa-lg"></i>
                        </div>
                    </div>
                    <h3 class="mb-0 fw-bold">{{ $stats['active_projects'] }}</h3>
                    <small class="text-muted">{{ __('Active Projects') }}</small>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-money-bill-wave text-success fa-lg"></i>
                        </div>
                    </div>
                    <h3 class="mb-0 fw-bold text-success">{{ number_format($stats['total_paid'], 2) }}</h3>
                    <small class="text-muted">{{ __('Total Received') }}</small>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100 border-start border-4 border-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="bg-warning bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-hourglass-half text-warning fa-lg"></i>
                        </div>
                    </div>
                    <h3 class="mb-0 fw-bold text-warning">{{ number_format($stats['total_pending'], 2) }}</h3>
                    <small class="text-muted">{{ __('Pending Balance') }}</small>
                </div>
            </div>
        </div>
    </div>

    <!-- My Projects -->
    <div class="card">
        <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-tasks me-2"></i>{{ __('My Projects') }}</h5>
            <a href="{{ route('programmer.payments') }}" class="btn btn-sm btn-outline-success">
                <i class="fas fa-history me-1"></i>{{ __('Payment History') }}
            </a>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th>{{ __('Project Name') }}</th>
                            <th>{{ __('Customer') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Progress') }}</th>
                            <th class="text-end">{{ __('My Commission') }}</th>
                            <th class="text-end">{{ __('Received') }}</th>
                            <th class="text-end">{{ __('Pending') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($projects as $project)
                        <tr>
                            <td class="fw-bold">{{ $project->name }}</td>
                            <td>{{ $project->customer->name }}</td>
                            <td>
                                @switch($project->status)
                                    @case('completed')
                                        <span class="badge bg-success">{{ __('Completed') }}</span>
                                        @break
                                    @case('in_progress')
                                        <span class="badge bg-info">{{ __('In Progress') }}</span>
                                        @break
                                    @case('pending')
                                        <span class="badge bg-warning text-dark">{{ __('Pending') }}</span>
                                        @break
                                    @case('on_hold')
                                        <span class="badge bg-secondary">{{ __('On Hold') }}</span>
                                        @break
                                    @default
                                        <span class="badge bg-danger">{{ __('Cancelled') }}</span>
                                @endswitch
                            </td>
                            <td>
                                <div class="progress" style="height: 8px; width: 100px;">
                                    <div class="progress-bar bg-primary" style="width: {{ $project->progress_percent }}%"></div>
                                </div>
                                <small class="text-muted">{{ $project->progress_percent }}%</small>
                            </td>
                            <td class="text-end fw-bold">{{ number_format($project->commission_amount, 2) }}</td>
                            <td class="text-end text-success">{{ number_format($project->paid_to_programmer, 2) }}</td>
                            <td class="text-end text-warning">{{ number_format($project->remaining_programmer_balance, 2) }}</td>
                            <td>
                                <a href="{{ route('programmer.project', $project) }}" class="btn btn-sm btn-outline-light">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                                <h5>{{ __('No projects assigned yet') }}</h5>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
