@extends('layouts.app')

@section('content')
    <div class="container-fluid py-4">
        <div class="row mb-4">
            <div class="col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a
                                href="{{ route('programmer.dashboard') }}">{{ __('My Dashboard') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Payment History') }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-8">
                <h2 class="fw-light mb-0">{{ __('My Payment History') }}</h2>
            </div>
            <div class="col-md-4 text-md-end">
                <a href="{{ route('programmer.dashboard') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-1"></i>{{ __('Back to Dashboard') }}
                </a>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row g-3 mb-4">
            <div class="col-md-4">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h6 class="mb-1">{{ __('Total Earned') }}</h6>
                        <h3 class="mb-0">{{ number_format($totals['total_earned'], 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h6 class="mb-1">{{ __('Total Received') }}</h6>
                        <h3 class="mb-0">{{ number_format($totals['total_paid'], 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-warning text-dark">
                    <div class="card-body text-center">
                        <h6 class="mb-1">{{ __('Pending Balance') }}</h6>
                        <h3 class="mb-0">{{ number_format($totals['pending'], 2) }}</h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payments Table -->
        <div class="card">
            <div class="card-header bg-transparent">
                <h5 class="mb-0"><i class="fas fa-history me-2"></i>{{ __('All Payments') }}</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>{{ __('Date') }}</th>
                                <th>{{ __('Project') }}</th>
                                <th class="text-end">{{ __('Amount') }}</th>
                                <th>{{ __('Notes') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($payments as $payment)
                                <tr>
                                    <td>{{ $payment->date instanceof \Carbon\Carbon ? $payment->date->format('Y-m-d') : $payment->date }}
                                    </td>
                                    <td>
                                        <a href="{{ route('programmer.project', $payment->project_id) }}"
                                            class="text-decoration-none">
                                            {{ $payment->project->name }}
                                        </a>
                                    </td>
                                    <td class="text-end text-success fw-bold">{{ number_format($payment->amount, 2) }}</td>
                                    <td>{{ $payment->notes ?: '-' }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center py-5">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <h5>{{ __('No payments recorded yet') }}</h5>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if($payments->hasPages())
                <div class="card-footer">
                    {{ $payments->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection