@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('programmer.dashboard') }}">{{ __('My Dashboard') }}</a></li>
                    <li class="breadcrumb-item active">{{ $project->name }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-8">
            <h2 class="fw-light mb-1">{{ $project->name }}</h2>
            <p class="text-muted">{{ __('Customer') }}: {{ $project->customer->name }}</p>
        </div>
        <div class="col-md-4 text-md-end">
            @switch($project->status)
                @case('completed')
                    <span class="badge bg-success fs-6">{{ __('Completed') }}</span>
                    @break
                @case('in_progress')
                    <span class="badge bg-info fs-6">{{ __('In Progress') }}</span>
                    @break
                @case('pending')
                    <span class="badge bg-warning text-dark fs-6">{{ __('Pending') }}</span>
                    @break
                @default
                    <span class="badge bg-secondary fs-6">{{ $project->status }}</span>
            @endswitch
        </div>
    </div>

    <div class="row g-4">
        <!-- Project Details -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header bg-transparent">
                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>{{ __('Project Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Start Date') }}</label>
                            <p class="mb-0 fw-bold">{{ $project->start_date ? $project->start_date->format('Y-m-d') : '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('End Date') }}</label>
                            <p class="mb-0 fw-bold">{{ $project->end_date ? $project->end_date->format('Y-m-d') : '-' }}</p>
                        </div>
                        <div class="col-12">
                            <label class="text-muted small">{{ __('Notes') }}</label>
                            <p class="mb-0">{{ $project->notes ?: __('No notes') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Update Progress Form -->
            @if($project->status != 'completed' && $project->status != 'cancelled')
            <div class="card mb-4">
                <div class="card-header bg-transparent">
                    <h5 class="mb-0"><i class="fas fa-tasks me-2"></i>{{ __('Update Progress') }}</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('programmer.update-progress', $project) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Progress Percentage') }}</label>
                                <input type="range" class="form-range" name="progress_percent" 
                                       value="{{ $project->progress_percent }}" min="0" max="100" step="5"
                                       oninput="this.nextElementSibling.value = this.value + '%'">
                                <output class="fw-bold">{{ $project->progress_percent }}%</output>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Notes') }}</label>
                                <textarea name="notes" class="form-control" rows="2">{{ $project->notes }}</textarea>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>{{ __('Update Progress') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @endif

            <!-- Payment History -->
            <div class="card">
                <div class="card-header bg-transparent">
                    <h5 class="mb-0"><i class="fas fa-history me-2"></i>{{ __('Payment History') }}</h5>
                </div>
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>{{ __('Date') }}</th>
                                <th class="text-end">{{ __('Amount') }}</th>
                                <th>{{ __('Notes') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($project->payments as $payment)
                            <tr>
                                <td>{{ $payment->date instanceof \Carbon\Carbon ? $payment->date->format('Y-m-d') : $payment->date }}</td>
                                <td class="text-end text-success fw-bold">{{ number_format($payment->amount, 2) }}</td>
                                <td>{{ $payment->notes ?: '-' }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="3" class="text-center py-4 text-muted">
                                    {{ __('No payments recorded yet') }}
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Sidebar Stats -->
        <div class="col-lg-4">
            <div class="card mb-4 border-success">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-wallet me-2"></i>{{ __('My Earnings') }}</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <span>{{ __('Commission') }}</span>
                        <strong>{{ number_format($project->commission_amount, 2) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-3 text-success">
                        <span>{{ __('Received') }}</span>
                        <strong>{{ number_format($project->paid_to_programmer, 2) }}</strong>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between fs-5">
                        <span class="text-warning">{{ __('Pending') }}</span>
                        <strong class="text-warning">{{ number_format($project->remaining_programmer_balance, 2) }}</strong>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-transparent">
                    <h5 class="mb-0"><i class="fas fa-chart-line me-2"></i>{{ __('Progress') }}</h5>
                </div>
                <div class="card-body text-center">
                    <div class="display-4 fw-bold text-primary mb-2">{{ $project->progress_percent }}%</div>
                    <div class="progress" style="height: 20px;">
                        <div class="progress-bar bg-primary" style="width: {{ $project->progress_percent }}%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
