@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">Backup & Restore</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('settings.index') }}">Settings</a></li>
                    <li class="breadcrumb-item active">Backup Configuration</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <!-- Manual Action -->
        <div class="col-md-4 mb-4">
            <div class="card bg-primary text-white h-100">
                <div class="card-body text-center d-flex flex-column justify-content-center align-items-center">
                    <i class="fas fa-database fa-4x mb-3"></i>
                    <h4 class="card-title">Manual Backup</h4>
                    <p class="card-text">Create and download a full database backup instantly.</p>
                    <form action="{{ route('settings.backup.download') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-light btn-lg mt-3 fw-bold text-primary">
                            <i class="fas fa-download me-2"></i>Download Database Backup
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Settings -->
        <div class="col-md-8 mb-4">
            <div class="card">
                <div class="card-header bg-dark border-secondary">
                    <h5 class="mb-0">Automated Destinations</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('settings.backup.update') }}" method="POST">
                        @csrf
                        @method('PUT')

                        <!-- Email Settings -->
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-envelope me-2"></i>Email Backup</h6>
                        <div class="mb-3 form-check form-switch">
                            <input type="checkbox" class="form-check-input" id="email_enabled" name="email_enabled"
                                value="1" {{ ($settings['email_enabled'] ?? 0) ? 'checked' : '' }}>
                            <label class="form-check-label" for="email_enabled">Send backup to email</label>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" name="email_address" class="form-control"
                                value="{{ $settings['email_address'] ?? '' }}" placeholder="admin@example.com">
                        </div>

                        <div class="mt-4"></div>

                        <!-- FTP Settings -->
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-server me-2"></i>FTP Upload</h6>
                        <div class="mb-3 form-check form-switch">
                            <input type="checkbox" class="form-check-input" id="ftp_enabled" name="ftp_enabled" value="1" {{ ($settings['ftp_enabled'] ?? 0) ? 'checked' : '' }}>
                            <label class="form-check-label" for="ftp_enabled">Upload to FTP Server</label>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">FTP Host</label>
                                <input type="text" name="ftp_host" class="form-control"
                                    value="{{ $settings['ftp_host'] ?? '' }}" placeholder="ftp.example.com">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">FTP Username</label>
                                <input type="text" name="ftp_username" class="form-control"
                                    value="{{ $settings['ftp_username'] ?? '' }}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">FTP Password</label>
                                <input type="password" name="ftp_password" class="form-control"
                                    value="{{ $settings['ftp_password'] ?? '' }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Upload Path</label>
                                <input type="text" name="ftp_path" class="form-control"
                                    value="{{ $settings['ftp_path'] ?? '/' }}" placeholder="/backups">
                            </div>
                        </div>

                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection