@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ __('Customer Groups') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('settings.index') }}">{{ __('Settings') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Customer Groups') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <!-- Create/Edit Form -->
        <div class="col-md-4 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Add New Group') }}</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('settings.customer-groups.store') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">{{ __('Group Name') }}</label>
                            <input type="text" name="name" class="form-control" placeholder="e.g. VIP, Gold" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Discount Percentage') }} (%)</label>
                            <input type="number" name="discount_percentage" class="form-control" step="0.01" min="0"
                                max="100" value="0">
                            <div class="form-text">{{ __('Default discount applied to invoices for members.') }}</div>
                        </div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Points Unit') }}</label>
                                <input type="number" name="points_unit" class="form-control" value="100" min="1" required>
                                <div class="form-text small">{{ __('e.g. 100 Points') }}</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Currency Value') }}</label>
                                <input type="number" name="currency_unit" class="form-control" value="0.00" step="0.01"
                                    min="0" required>
                                <div class="form-text small">{{ __('e.g. 10.00') }}</div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Description') }}</label>
                            <textarea name="description" class="form-control" rows="3"></textarea>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>{{ __('Create Group') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Groups List -->
        <div class="col-md-8">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('Existing Groups') }}</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Discount') }}</th>
                                    <th>{{ __('Redemption Rate') }}</th>
                                    <th>{{ __('Members') }}</th>
                                    <th class="text-end">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($groups as $group)
                                    <tr>
                                        <td>
                                            <div class="fw-bold">{{ $group->name }}</div>
                                            <div class="small text-muted">{{ $group->description }}</div>
                                        </td>
                                        <td>
                                            <span
                                                class="badge bg-success">{{ number_format($group->discount_percentage, 0) }}%</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $group->points_unit }} Pts =
                                                {{ number_format($group->currency_unit, 2) }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary">{{ $group->customers_count }} Customers</span>
                                        </td>
                                        <td class="text-end">
                                            <button class="btn btn-sm btn-outline-warning me-1"
                                                onclick="editGroup({{ $group->id }}, '{{ $group->name }}', {{ $group->discount_percentage }}, '{{ $group->description }}', {{ $group->points_unit }}, {{ $group->currency_unit }})">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="{{ route('settings.customer-groups.destroy', $group) }}" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('{{ __('Are you sure? This cannot be undone if customers are assigned.') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger" {{ $group->customers_count > 0 ? 'disabled' : '' }}>
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center py-4 text-muted">
                                            {{ __('No customer groups defined yet.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editGroupModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editGroupForm" action="" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-content bg-dark">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">{{ __('Edit Customer Group') }}</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">{{ __('Group Name') }}</label>
                            <input type="text" name="name" id="edit_name" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Discount Percentage') }} (%)</label>
                            <input type="number" name="discount_percentage" id="edit_discount" class="form-control"
                                step="0.01" min="0" max="100">
                        </div>
                        <div class="row g-2 mb-3">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Points Unit') }}</label>
                                <input type="number" name="points_unit" id="edit_points" class="form-control" min="1"
                                    required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Currency Value') }}</label>
                                <input type="number" name="currency_unit" id="edit_currency" class="form-control"
                                    step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">{{ __('Description') }}</label>
                            <textarea name="description" id="edit_description" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        function editGroup(id, name, discount, description, points, currency) {
            document.getElementById('editGroupForm').action = "{{ url('settings/customer-groups') }}/" + id;
            document.getElementById('edit_name').value = name;
            document.getElementById('edit_discount').value = discount;
            document.getElementById('edit_description').value = description; // Might need escaping/handling
            document.getElementById('edit_points').value = points;
            document.getElementById('edit_currency').value = currency;

            var myModal = new bootstrap.Modal(document.getElementById('editGroupModal'));
            myModal.show();
        }
    </script>
@endsection