@extends('layouts.app')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="page-title">{{ __('Modules & Features') }}</h1>
            <p class="page-subtitle">{{ __('Enable or disable system modules to customize your experience.') }}</p>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <form action="{{ route('settings.modules.update') }}" method="POST">
        @csrf
        <div class="row">
            @foreach($modules as $key => $module)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 {{ isset($settings[$key]) && $settings[$key] == '1' ? 'border-primary' : 'border-secondary' }}">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="{{ $key }}" id="{{ $key }}" 
                                        {{ isset($settings[$key]) ? ($settings[$key] == '1' ? 'checked' : '') : ($module['default'] ? 'checked' : '') }}>
                                    <label class="form-check-label fw-bold" for="{{ $key }}">{{ __($module['name']) }}</label>
                                </div>
                                <i class="fas fa-{{ $key == 'module_ai' ? 'robot' : ($key == 'module_inventory' ? 'boxes' : 'check-circle') }} text-{{ isset($settings[$key]) && $settings[$key] == '1' ? 'primary' : 'muted' }} fa-lg"></i>
                            </div>
                            <p class="text-muted small mb-0">{{ __($module['description']) }}</p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="card mt-2">
            <div class="card-body d-flex justify-content-end">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save me-2"></i>{{ __('Save Changes') }}
                </button>
            </div>
        </div>
    </form>

    <div class="alert alert-info mt-4">
        <i class="fas fa-info-circle me-2"></i>
        <strong>{{ __('Note:') }}</strong> {{ __('Disabling a module will hide it from the sidebar and restrict access to its pages.') }}
    </div>
@endsection
