@extends('layouts.app')

@section('content')
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card glass-card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0 px-4 pt-4">
                        <h2 class="h4 mb-0">{{ __('New Role') }}</h2>
                    </div>
                    <div class="card-body p-4">
                        <form action="{{ route('settings.roles.store') }}" method="POST">
                            @csrf
                            <div class="mb-5">
                                <label
                                    class="form-label fw-bold small text-muted text-uppercase">{{ __('Role Name') }}</label>
                                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                    value="{{ old('name') }}" placeholder="e.g. manager" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-4">
                                <label
                                    class="form-label fw-bold small text-muted text-uppercase mb-3">{{ __('Permissions') }}</label>
                                <div class="row g-4">
                                    @php
                                        $groupedPermissions = $permissions->groupBy(function ($item) {
                                            return explode(' ', $item->name)[count(explode(' ', $item->name)) - 1];
                                        });
                                    @endphp
                                    @foreach($groupedPermissions as $group => $items)
                                        <div class="col-md-4">
                                            <div class="p-3 bg-light rounded shadow-sm h-100">
                                                <h6 class="fw-bold text-primary mb-3 text-uppercase small">
                                                    {{ __(strtoupper($group)) }}</h6>
                                                @foreach($items as $permission)
                                                    <div class="form-check mb-2">
                                                        <input class="form-check-input" type="checkbox" name="permissions[]"
                                                            value="{{ $permission->name }}" id="perm_{{ $permission->id }}">
                                                        <label class="form-check-label small" for="perm_{{ $permission->id }}">
                                                            {{ __($permission->name) }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="d-flex justify-content-between mt-5">
                                <a href="{{ route('settings.roles.index') }}" class="btn btn-light border">
                                    {{ __('Cancel') }}
                                </a>
                                <button type="submit" class="btn btn-primary px-4">
                                    {{ __('Create') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection