@extends('layouts.app')

@section('content')
<style>
    .perm-grid-card {
        background: #1a1e2b;
        border: 1px solid rgba(255,255,255,0.05);
        border-radius: 12px;
    }
    .perm-table th {
        background: #131722;
        color: #8f9bb3;
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        padding: 1.2rem;
        border-bottom: 1px solid rgba(255,255,255,0.05) !important;
    }
    .perm-table td {
        padding: 1rem 1.2rem;
        border-bottom: 1px solid rgba(255,255,255,0.02) !important;
        vertical-align: middle;
        color: #e4e9f2;
    }
    .perm-table tr:hover {
        background: rgba(255,255,255,0.02);
    }
    .module-name {
        font-weight: 600;
        font-size: 0.95rem;
    }
    .form-check-input {
        background-color: transparent;
        border: 2px solid #3366ff;
        width: 1.2rem;
        height: 1.2rem;
        cursor: pointer;
    }
    .form-check-input:checked {
        background-color: #3366ff;
        border-color: #3366ff;
    }
    .text-danger-custom { color: #ff3d71; }
    .perm-label {
        color: #8f9bb3;
        font-size: 0.8rem;
        margin-right: 8px;
    }
    .grid-header-note {
        color: #8f9bb3;
        font-size: 0.85rem;
        margin-bottom: 1.5rem;
    }
</style>

<div class="page-header d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="page-title text-white">{{ __('Edit Role') }}: {{ strtoupper($role->name) }}</h1>
        <p class="text-muted small mb-0">{{ __('Define granular access control for this user group.') }}</p>
    </div>
    <a href="{{ route('settings.roles.index') }}" class="btn btn-outline-secondary btn-sm">
        <i class="fas fa-arrow-left me-2"></i>{{ __('Back to Roles') }}
    </a>
</div>

<form action="{{ route('settings.roles.update', $role) }}" method="POST">
    @csrf
    @method('PUT')

    <div class="row">
        <div class="col-md-12">
            <div class="card perm-grid-card mb-4">
                <div class="card-body p-4">
                    <div class="mb-4">
                        <label class="form-label text-muted small text-uppercase fw-bold">{{ __('Role Name') }}</label>
                        <input type="text" name="name" class="form-control bg-dark border-0 text-white" 
                            value="{{ old('name', $role->name) }}" {{ $role->name === 'admin' ? 'readonly' : '' }} required>
                    </div>

                    <div class="grid-header-note text-end">
                        .Check all data to enable viewing of all data. By unchecking this, the user under this Role will see only the data created by that user
                    </div>

                    <div class="table-responsive">
                        <table class="table perm-table mb-0">
                            <thead>
                                <tr>
                                    <th>{{ __('Module Name') }}</th>
                                    @foreach($actions as $key => $label)
                                        <th class="text-center {{ $key == 'delete' ? 'text-danger-custom' : '' }}">{{ __($label) }}</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($modules as $moduleLabel => $moduleKey)
                                    <tr>
                                        <td class="module-name">{{ __($moduleLabel) }}</td>
                                        @foreach($actions as $actionKey => $actionLabel)
                                            @php
                                                $permName = "{$actionKey} {$moduleKey}";
                                                $hasPerm = $role->hasPermissionTo($permName);
                                            @endphp
                                            <td class="text-center">
                                                <div class="form-check form-check-inline m-0">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" 
                                                        value="{{ $permName }}" {{ $hasPerm ? 'checked' : '' }} 
                                                        {{ $role->name === 'admin' ? 'disabled' : '' }}>
                                                </div>
                                            </td>
                                        @endforeach
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-transparent border-top border-white border-opacity-5 p-4 text-end">
                    <button type="submit" class="btn btn-primary px-5" {{ $role->name === 'admin' ? 'disabled' : '' }}>
                        {{ __('Save Changes') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection