@extends('layouts.app')

@section('content')
    <div class="container-fluid py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="h4 mb-0">{{ __('Roles') }}</h2>
            <a href="{{ route('settings.roles.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-1"></i> {{ __('Add Role') }}
            </a>
        </div>

        <div class="card glass-card border-0 shadow-sm">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light text-muted small text-uppercase">
                        <tr>
                            <th class="px-4">{{ __('Role Name') }}</th>
                            <th>{{ __('Permissions') }}</th>
                            <th class="text-end px-4">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($roles as $role)
                            <tr>
                                <td class="px-4">
                                    <span class="fw-bold text-primary">{{ strtoupper($role->name) }}</span>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($role->permissions as $permission)
                                            <span
                                                class="badge bg-secondary-soft text-secondary small">{{ $permission->name }}</span>
                                        @endforeach
                                    </div>
                                </td>
                                <td class="text-end px-4">
                                    <div class="btn-group">
                                        <a href="{{ route('settings.roles.edit', $role) }}" class="btn btn-sm btn-light border">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if($role->name !== 'admin')
                                            <form action="{{ route('settings.roles.destroy', $role) }}" method="POST"
                                                class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-light border text-danger"
                                                    onclick="return confirm('{{ __('Are you sure?') }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection