@extends('layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-light">{{ isset($template) ? __('Edit Template') : __('Add New Template') }}</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a
                            href="{{ route('settings.whatsapp.index') }}">{{ __('WhatsApp Templates') }}</a></li>
                    <li class="breadcrumb-item active">{{ isset($template) ? __('Edit') : __('Create') }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card glass-card">
                <div class="card-body">
                    <form
                        action="{{ isset($template) ? route('settings.whatsapp.update', $template) : route('settings.whatsapp.store') }}"
                        method="POST">
                        @csrf
                        @if(isset($template)) @method('PUT') @endif

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">{{ __('Template Name') }}</label>
                                <input type="text" name="name" class="form-control bg-black text-white border-secondary"
                                    value="{{ old('name', $template->name ?? '') }}" required
                                    placeholder="{{ __('e.g., New Invoice Notification') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('System Key') }}</label>
                                <input type="text" name="key" class="form-control bg-black text-white border-secondary"
                                    value="{{ old('key', $template->key ?? '') }}" required
                                    placeholder="{{ __('e.g., invoice_notify') }}" {{ isset($template) ? 'readonly' : '' }}>
                            </div>
                            <div class="col-12">
                                <label class="form-label">{{ __('Message Content') }}</label>
                                <textarea name="content" class="form-control bg-black text-white border-secondary" rows="8"
                                    required
                                    placeholder="{{ __('Enter message text here...') }}">{{ old('content', $template->content ?? '') }}</textarea>
                                <div class="form-text text-muted">
                                    {{ __('Use curly braces for placeholders, e.g.,') }} <code>{customer_name}</code>,
                                    <code>{invoice_id}</code>
                                </div>
                            </div>
                            <div class="col-12">
                                <label class="form-label">{{ __('Placeholders (for UI reference)') }}</label>
                                <input type="text" name="variables"
                                    class="form-control bg-black text-white border-secondary"
                                    value="{{ old('variables', $template->variables ?? '') }}"
                                    placeholder="{{ __('e.g., name, id, total') }}">
                            </div>
                            <div class="col-12">
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active"
                                        value="1" {{ old('is_active', $template->is_active ?? true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">{{ __('Active') }}</label>
                                </div>
                            </div>
                        </div>

                        <hr class="border-secondary my-4">

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('settings.whatsapp.index') }}"
                                class="btn btn-outline-light">{{ __('Cancel') }}</a>
                            <button type="submit" class="btn btn-primary px-5">{{ __('Save Template') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card bg-info bg-opacity-10 border-info border-start border-4">
                <div class="card-body">
                    <h5 class="text-info"><i class="fas fa-info-circle me-2"></i>{{ __('Formatting Tips') }}</h5>
                    <ul class="small mb-0 mt-3">
                        <li class="mb-2"><strong>*Bold*</strong> -> *نص عريض*</li>
                        <li class="mb-2">_Italic_ -> _نص مائل_</li>
                        <li class="mb-2">~Strikethrough~ -> ~نص مشطوب~</li>
                        <li class="mb-2">`Monospace` -> `شفرة`</li>
                        <li>{{ __('Ensure all placeholders used in the content are listed in the variables field for better management.') }}
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <style>
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
    </style>
@endsection