@extends('layouts.app')

@section('content')
    <div class="row mb-4 align-items-center">
        <div class="col-12 col-md-6">
            <h2 class="fw-light mb-0">{{ __('WhatsApp Templates') }}</h2>
            <p class="text-muted small mb-0">
                {{ __('Manage dynamic placeholders and professional communication templates') }}
            </p>
        </div>
        <div class="col-12 col-md-6 text-md-end mt-3 mt-md-0">
            <a href="{{ route('settings.whatsapp.create') }}" class="btn btn-primary shadow-sm">
                <i class="fas fa-plus-circle me-1"></i> {{ __('Add Template') }}
            </a>
        </div>
    </div>

    <div class="card glass-card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark align-middle mb-0">
                    <thead class="bg-black">
                        <tr>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Key') }}</th>
                            <th>{{ __('Placeholders') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th class="text-end">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($templates as $template)
                            <tr>
                                <td data-label="{{ __('Name') }}"><strong>{{ $template->name }}</strong></td>
                                <td data-label="{{ __('Key') }}"><code>{{ $template->key }}</code></td>
                                <td data-label="{{ __('Placeholders') }}">
                                    @foreach(explode(',', $template->variables) as $var)
                                        <span class="badge bg-secondary mb-1">{{ trim($var) }}</span>
                                    @endforeach
                                </td>
                                <td data-label="{{ __('Status') }}">
                                    <span class="badge bg-{{ $template->is_active ? 'success' : 'danger' }}">
                                        {{ $template->is_active ? __('Active') : __('Inactive') }}
                                    </span>
                                </td>
                                <td data-label="{{ __('Actions') }}" class="text-end">
                                    <div class="btn-group">
                                        <a href="{{ route('settings.whatsapp.edit', $template) }}"
                                            class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('settings.whatsapp.destroy', $template) }}" method="POST"
                                            class="d-inline" onsubmit="return confirm('{{ __('Are you sure?') }}')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-5 text-muted">
                                    <i class="fas fa-comment-slash fa-3x mb-3"></i>
                                    <h5>{{ __('No templates found') }}</h5>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                {{ $templates->links() }}
            </div>
        </div>
    </div>

    <style>
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
    </style>
@endsection