

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="page-title"><?php echo e(__('Modules & Features')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Enable or disable system modules to customize your experience.')); ?></p>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('settings.modules.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card h-100 <?php echo e(isset($settings[$key]) && $settings[$key] == '1' ? 'border-primary' : 'border-secondary'); ?>">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="<?php echo e($key); ?>" id="<?php echo e($key); ?>" 
                                        <?php echo e(isset($settings[$key]) ? ($settings[$key] == '1' ? 'checked' : '') : ($module['default'] ? 'checked' : '')); ?>>
                                    <label class="form-check-label fw-bold" for="<?php echo e($key); ?>"><?php echo e(__($module['name'])); ?></label>
                                </div>
                                <i class="fas fa-<?php echo e($key == 'module_ai' ? 'robot' : ($key == 'module_inventory' ? 'boxes' : 'check-circle')); ?> text-<?php echo e(isset($settings[$key]) && $settings[$key] == '1' ? 'primary' : 'muted'); ?> fa-lg"></i>
                            </div>
                            <p class="text-muted small mb-0"><?php echo e(__($module['description'])); ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="card mt-2">
            <div class="card-body d-flex justify-content-end">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save me-2"></i><?php echo e(__('Save Changes')); ?>

                </button>
            </div>
        </div>
    </form>

    <div class="alert alert-info mt-4">
        <i class="fas fa-info-circle me-2"></i>
        <strong><?php echo e(__('Note:')); ?></strong> <?php echo e(__('Disabling a module will hide it from the sidebar and restrict access to its pages.')); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/settings/modules.blade.php ENDPATH**/ ?>