

<?php $__env->startSection('content'); ?>
    <div class="row mb-4 align-items-center">
        <div class="col-12 col-md-6">
            <h2 class="fw-light mb-0"><?php echo e(__('WhatsApp Templates')); ?></h2>
            <p class="text-muted small mb-0">
                <?php echo e(__('Manage dynamic placeholders and professional communication templates')); ?>

            </p>
        </div>
        <div class="col-12 col-md-6 text-md-end mt-3 mt-md-0">
            <a href="<?php echo e(route('settings.whatsapp.create')); ?>" class="btn btn-primary shadow-sm">
                <i class="fas fa-plus-circle me-1"></i> <?php echo e(__('Add Template')); ?>

            </a>
        </div>
    </div>

    <div class="card glass-card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover table-dark align-middle mb-0">
                    <thead class="bg-black">
                        <tr>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Key')); ?></th>
                            <th><?php echo e(__('Placeholders')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th class="text-end"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Name')); ?>"><strong><?php echo e($template->name); ?></strong></td>
                                <td data-label="<?php echo e(__('Key')); ?>"><code><?php echo e($template->key); ?></code></td>
                                <td data-label="<?php echo e(__('Placeholders')); ?>">
                                    <?php $__currentLoopData = explode(',', $template->variables); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $var): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-secondary mb-1"><?php echo e(trim($var)); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td data-label="<?php echo e(__('Status')); ?>">
                                    <span class="badge bg-<?php echo e($template->is_active ? 'success' : 'danger'); ?>">
                                        <?php echo e($template->is_active ? __('Active') : __('Inactive')); ?>

                                    </span>
                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('settings.whatsapp.edit', $template)); ?>"
                                            class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('settings.whatsapp.destroy', $template)); ?>" method="POST"
                                            class="d-inline" onsubmit="return confirm('<?php echo e(__('Are you sure?')); ?>')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center py-5 text-muted">
                                    <i class="fas fa-comment-slash fa-3x mb-3"></i>
                                    <h5><?php echo e(__('No templates found')); ?></h5>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="p-3">
                <?php echo e($templates->links()); ?>

            </div>
        </div>
    </div>

    <style>
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/settings/system/whatsapp/index.blade.php ENDPATH**/ ?>