

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="page-header mb-4">
        <h1 class="page-title"><?php echo e(__('Record New Expense')); ?></h1>
        <p class="page-subtitle"><?php echo e(__('Add a generalized expense transaction')); ?></p>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card glass-card premium-shadow">
                <div class="card-body p-4">
                    <form action="<?php echo e(route('accounting.expenses.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row g-4">
                            <!-- Category Selection -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold"><?php echo e(__('Expense Category')); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-tags"></i></span>
                                    <select name="category_id" class="form-select border-start-0" required>
                                        <option value=""><?php echo e(__('Select Category')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                                <?php echo e($category->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-text small"><?php echo e(__('Categories like: Rent, Salaries, Electricity, etc.')); ?></div>
                                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Treasury Selection -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold"><?php echo e(__('Pay From (Treasury)')); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-vault"></i></span>
                                    <select name="treasury_id" class="form-select border-start-0" required id="treasurySelect">
                                        <option value=""><?php echo e(__('Select Treasury')); ?></option>
                                        <?php $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($treasury->id); ?>" 
                                                    data-balance="<?php echo e($treasury->balance); ?>"
                                                    data-currency="<?php echo e($treasury->currency->code ?? ''); ?>"
                                                    <?php echo e(old('treasury_id') == $treasury->id ? 'selected' : ''); ?>>
                                                <?php echo e($treasury->name); ?> (<?php echo e(number_format($treasury->balance, 2)); ?> <?php echo e($treasury->currency->code ?? ''); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div id="balanceWarning" class="text-warning small mt-1 d-none">
                                    <i class="fas fa-exclamation-triangle me-1"></i> <?php echo e(__('Amount exceeds available balance!')); ?>

                                </div>
                                <?php $__errorArgs = ['treasury_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Amount -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold"><?php echo e(__('Amount')); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-dollar-sign"></i></span>
                                    <input type="number" step="0.01" name="amount" id="amountInput" class="form-control border-start-0" placeholder="0.00" value="<?php echo e(old('amount')); ?>" required>
                                </div>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Date -->
                            <div class="col-md-6">
                                <label class="form-label fw-bold"><?php echo e(__('Expense Date')); ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-calendar"></i></span>
                                    <input type="date" name="date" class="form-control border-start-0" value="<?php echo e(old('date', date('Y-m-d'))); ?>" required>
                                </div>
                                <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Reference Number -->
                            <div class="col-md-12">
                                <label class="form-label fw-bold"><?php echo e(__('Reference / Receipt No.')); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-transparent border-end-0 text-muted"><i class="fas fa-hashtag"></i></span>
                                    <input type="text" name="ref_no" class="form-control border-start-0" placeholder="<?php echo e(__('Optional reference number')); ?>" value="<?php echo e(old('ref_no')); ?>">
                                </div>
                            </div>

                            <!-- Description -->
                            <div class="col-12">
                                <label class="form-label fw-bold"><?php echo e(__('Description / Statement')); ?> <span class="text-danger">*</span></label>
                                <textarea name="description" class="form-control" rows="3" placeholder="<?php echo e(__('Write a detailed description of the expense...')); ?>" required><?php echo e(old('description')); ?></textarea>
                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Submit Buttons -->
                            <div class="col-12 mt-4">
                                <hr class="border-secondary opacity-25">
                                <div class="d-flex justify-content-between">
                                    <a href="<?php echo e(route('accounting.expenses.index')); ?>" class="btn btn-outline-secondary px-4 glass-card">
                                        <i class="fas fa-times me-2"></i> <?php echo e(__('Cancel')); ?>

                                    </a>
                                    <button type="submit" class="btn btn-primary px-5 premium-shadow">
                                        <i class="fas fa-save me-2"></i> <?php echo e(__('Record Expense')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const treasurySelect = document.getElementById('treasurySelect');
        const amountInput = document.getElementById('amountInput');
        const balanceWarning = document.getElementById('balanceWarning');

        function checkBalance() {
            const selected = treasurySelect.options[treasurySelect.selectedIndex];
            if (!selected || !selected.value) return;

            const balance = parseFloat(selected.dataset.balance);
            const amount = parseFloat(amountInput.value) || 0;

            if (amount > balance) {
                balanceWarning.classList.remove('d-none');
            } else {
                balanceWarning.classList.add('d-none');
            }
        }

        treasurySelect.addEventListener('change', checkBalance);
        amountInput.addEventListener('input', checkBalance);
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/expenses/create.blade.php ENDPATH**/ ?>