

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-light"><?php echo e(__('Subscriptions')); ?></h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Subscriptions')); ?></li>
                    </ol>
                </nav>
            </div>
            <div>
                <form action="<?php echo e(route('accounting.whmcs.sync-subscriptions')); ?>" method="POST" class="d-inline-block me-2">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-outline-success">
                        <i class="fas fa-sync me-2"></i><?php echo e(__('Sync WHMCS')); ?>

                    </button>
                </form>
                <a href="<?php echo e(route('accounting.subscriptions.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i><?php echo e(__('New Subscription')); ?>

                </a>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header bg-dark border-secondary">
            <h5 class="mb-0"><?php echo e(__('Active Subscriptions')); ?></h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Service/Product')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <th><?php echo e(__('Price')); ?></th>
                            <th><?php echo e(__('Billing Cycle')); ?></th>
                            <th><?php echo e(__('Next Due Date')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('WHMCS')); ?></th>
                            <th class="text-end"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Service/Product')); ?>">
                                    <div class="fw-bold text-white"><?php echo e($sub->service_name); ?></div>
                                </td>
                                <td data-label="<?php echo e(__('Customer')); ?>">
                                    <?php if($sub->customer): ?>
                                        <a href="<?php echo e(route('customers.show', $sub->customer_id)); ?>" class="text-decoration-none">
                                            <?php echo e($sub->customer->name); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(__('Unknown')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Price')); ?>"><?php echo e(number_format($sub->price, 2)); ?> <?php echo e(__($sub->currency)); ?>

                                </td>
                                <td data-label="<?php echo e(__('Billing Cycle')); ?>"><?php echo e(__($sub->billing_cycle)); ?></td>
                                <td data-label="<?php echo e(__('Next Due Date')); ?>">
                                    <?php if($sub->next_due_date): ?>
                                        <span class="<?php echo e($sub->next_due_date->isPast() ? 'text-danger' : 'text-success'); ?>">
                                            <?php echo e($sub->next_due_date->format('Y-m-d')); ?>

                                        </span>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Status')); ?>">
                                    <span
                                        class="badge bg-<?php echo e($sub->status === 'active' ? 'success' : ($sub->status === 'cancelled' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(__($sub->status)); ?>

                                    </span>
                                </td>
                                <td data-label="<?php echo e(__('WHMCS')); ?>">
                                    <?php if($sub->whmcs_service_id): ?>
                                        <span class="badge bg-info"><?php echo e(__('Linked')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(__('Local')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                                    <a href="<?php echo e(route('accounting.subscriptions.edit', $sub->id)); ?>"
                                        class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4 text-muted"><?php echo e(__('No subscriptions found.')); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center mt-3">
                <?php echo e($subscriptions->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/subscriptions/index.blade.php ENDPATH**/ ?>