

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="page-title"><?php echo e(__('Quotations')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Manage price offers and estimates for your customers')); ?></p>
        </div>
        <a href="<?php echo e(route('accounting.quotations.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i><?php echo e(__('New Quotation')); ?>

        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Number')); ?></th>
                            <th><?php echo e(__('Customer')); ?></th>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Expiry')); ?></th>
                            <th><?php echo e(__('Total')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('accounting.quotations.show', $quotation)); ?>"
                                        class="fw-bold text-decoration-none">
                                        <?php echo e($quotation->quotation_number); ?>

                                    </a>
                                </td>
                                <td><?php echo e($quotation->customer->name); ?></td>
                                <td><?php echo e($quotation->date->format('Y-m-d')); ?></td>
                                <td><?php echo e($quotation->expiry_date ? $quotation->expiry_date->format('Y-m-d') : '-'); ?></td>
                                <td><?php echo e(number_format($quotation->grand_total, 2)); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($quotation->status_color); ?>">
                                        <?php echo e(__($quotation->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?php echo e(route('accounting.quotations.show', $quotation)); ?>"
                                            class="btn btn-outline-info" title="<?php echo e(__('View')); ?>">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php if($quotation->status !== 'converted'): ?>
                                            <a href="<?php echo e(route('accounting.quotations.edit', $quotation)); ?>"
                                                class="btn btn-outline-warning" title="<?php echo e(__('Edit')); ?>">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('accounting.quotations.convert', $quotation)); ?>" method="POST"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-outline-success"
                                                </button>
                                            </form>
                                            </a>
                                            <form action="<?php echo e(route('accounting.quotations.destroy', $quotation)); ?>" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this quotation?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-outline-danger" title="<?php echo e(__('Delete')); ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>

                                        <?php endif; ?>
                                        <a href="<?php echo e(route('accounting.quotations.print', $quotation)); ?>"
                                            class="btn btn-outline-secondary" title="<?php echo e(__('Print')); ?>" target="_blank">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="text-muted mb-2"><i class="fas fa-file-alt fa-3x"></i></div>
                                    <p><?php echo e(__('No quotations found.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                <?php echo e($quotations->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/quotations/index.blade.php ENDPATH**/ ?>