

<?php $__env->startSection('content'); ?>
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title"><?php echo e(__('Loyalty System Dashboard')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Track Points and Customer Engagement')); ?></p>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="stat-card green h-100">
                <div class="stat-icon"><i class="fas fa-gift"></i></div>
                <div class="stat-value"><?php echo e(number_format($totalEarned, 0)); ?> <small class="fs-6 text-muted">Pts</small>
                </div>
                <div class="stat-label"><?php echo e(__('Total Points Earned')); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card orange h-100">
                <div class="stat-icon"><i class="fas fa-ticket-alt"></i></div>
                <div class="stat-value"><?php echo e(number_format($totalRedeemed, 0)); ?> <small class="fs-6 text-muted">Pts</small>
                </div>
                <div class="stat-label"><?php echo e(__('Total Points Redeemed')); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card pink h-100"> <!-- Pink for Liability/Balance -->
                <div class="stat-icon"><i class="fas fa-wallet"></i></div>
                <div class="stat-value"><?php echo e(number_format($totalLiability, 0)); ?> <small class="fs-6 text-muted">Pts</small>
                </div>
                <div class="stat-label"><?php echo e(__('Outstanding Liability')); ?></div>
                <div class="stat-trend down text-white-50 mt-1">
                    <?php echo e(__('Active Points Held by Customers')); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card glass-card mb-4">
        <div class="card-body">
            <form action="<?php echo e(route('loyalty.index')); ?>" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label"><?php echo e(__('Customer')); ?></label>
                    <select name="customer_id" class="form-select">
                        <option value=""><?php echo e(__('All Customers')); ?></option>
                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($customer->id); ?>" <?php echo e(request('customer_id') == $customer->id ? 'selected' : ''); ?>>
                                <?php echo e($customer->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label"><?php echo e(__('Transaction Type')); ?></label>
                    <select name="type" class="form-select">
                        <option value=""><?php echo e(__('All Types')); ?></option>
                        <option value="earned" <?php echo e(request('type') == 'earned' ? 'selected' : ''); ?>><?php echo e(__('Earned')); ?></option>
                        <option value="redeemed" <?php echo e(request('type') == 'redeemed' ? 'selected' : ''); ?>><?php echo e(__('Redeemed')); ?>

                        </option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Date From')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Date To')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="col-md-2 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary w-100"><i
                            class="fas fa-filter me-2"></i><?php echo e(__('Filter')); ?></button>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="card glass-card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-history me-2"></i><?php echo e(__('Points Log')); ?></h5>
        </div>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th><?php echo e(__('Date')); ?></th>
                        <th><?php echo e(__('Customer')); ?></th>
                        <th><?php echo e(__('Type')); ?></th>
                        <th><?php echo e(__('Points')); ?></th>
                        <th><?php echo e(__('Reference')); ?></th>
                        <th><?php echo e(__('Description')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($transaction->date->format('Y-m-d H:i')); ?></td>
                            <td>
                                <?php if($transaction->customer): ?>
                                    <a href="<?php echo e(route('customers.show', $transaction->customer)); ?>"
                                        class="text-white text-decoration-none">
                                        <?php echo e($transaction->customer->name); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="text-muted"><?php echo e(__('Unknown')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($transaction->type == 'earned'): ?>
                                    <span class="badge bg-success"><?php echo e(__('Earned')); ?></span>
                                <?php elseif($transaction->type == 'redeemed'): ?>
                                    <span class="badge bg-danger"><?php echo e(__('Redeemed')); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><?php echo e(ucfirst($transaction->type)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="<?php echo e($transaction->points > 0 ? 'text-success' : 'text-danger'); ?> fw-bold">
                                <?php echo e($transaction->points > 0 ? '+' : ''); ?><?php echo e(number_format($transaction->points, 0)); ?>

                            </td>
                            <td>
                                <?php if($transaction->reference_type == 'App\Models\Invoice' && $transaction->reference_id): ?>
                                    <a href="<?php echo e(route('accounting.invoices.show', $transaction->reference_id)); ?>"
                                        class="badge bg-primary text-decoration-none">
                                        <i class="fas fa-file-invoice me-1"></i>#<?php echo e($transaction->reference_id); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($transaction->description); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5 text-muted">
                                <i class="fas fa-box-open fa-3x mb-3"></i>
                                <p><?php echo e(__('No transactions found.')); ?></p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="card-footer bg-transparent border-0 d-flex justify-content-end">
            <?php echo e($transactions->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/loyalty/index.blade.php ENDPATH**/ ?>