

<?php $__env->startSection('content'); ?>
    <div class="row mb-4 align-items-center">
        <div class="col-12 col-md-6">
            <h2 class="fw-light mb-0"><?php echo e(__('System Updates')); ?></h2>
            <p class="text-muted small mb-0"><?php echo e(__('Maintain your system health and deploy new features')); ?></p>
        </div>
        <div class="col-12 col-md-6 text-md-end mt-3 mt-md-0">
            <span class="badge bg-secondary p-2"><?php echo e(__('Current Version')); ?>: <?php echo e($currentVersion); ?></span>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-5">
            <div class="card glass-card h-100">
                <div class="card-header border-secondary bg-black bg-opacity-30">
                    <h5 class="mb-0"><i class="fas fa-upload me-2"></i><?php echo e(__('Upload Update Package')); ?></h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('settings.updates.upload')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="mb-4">
                            <label class="form-label"><?php echo e(__('Select Update File (.zip or .php)')); ?></label>
                            <input type="file" name="update_file" class="form-control bg-black text-white border-secondary"
                                required>
                            <div class="form-text text-muted small mt-2">
                                <?php echo e(__('Ensure the file is from a trusted source. PHP scripts will be executed with full system privileges.')); ?>

                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-cloud-upload-alt me-2"></i><?php echo e(__('Upload File')); ?>

                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-7">
            <div class="card glass-card h-100">
                <div class="card-header border-secondary bg-black bg-opacity-30">
                    <h5 class="mb-0"><i class="fas fa-history me-2"></i><?php echo e(__('Available Updates')); ?></h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive table-responsive-stack">
                        <table class="table table-hover table-dark align-middle mb-0">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('File Name')); ?></th>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th class="text-end"><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $updateFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td data-label="<?php echo e(__('File Name')); ?>"><code><?php echo e($file->getFilename()); ?></code></td>
                                        <td data-label="<?php echo e(__('Date')); ?>" class="small">
                                            <?php echo e(date('Y-m-d H:i', $file->getMTime())); ?></td>
                                        <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                                            <form action="<?php echo e(route('settings.updates.run')); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="filename" value="<?php echo e($file->getFilename()); ?>">
                                                <button type="submit" class="btn btn-sm btn-success shadow-sm"
                                                    onclick="return confirm('<?php echo e(__('Are you sure you want to run this update? This may modify files and database.')); ?>')">
                                                    <i class="fas fa-play me-1"></i> <?php echo e(__('Run Update')); ?>

                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center py-5 text-muted">
                                            <i class="fas fa-box-open fa-2x mb-3"></i>
                                            <p><?php echo e(__('No update files uploaded yet.')); ?></p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/settings/system/updates/index.blade.php ENDPATH**/ ?>