

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-4">
            <h2 class="fw-light mb-0"><?php echo e(__('Purchases & Expenses')); ?></h2>
            <p class="text-muted small"><?php echo e(__('Track supplier bills, payments, and outgoing cashflow')); ?></p>
        </div>
        <div class="col-12 col-md-8 text-md-end">
            <a href="<?php echo e(route('accounting.bills.create')); ?>" class="btn btn-primary shadow-sm px-4">
                <i class="fas fa-plus-circle me-2"></i><?php echo e(__('Record New Bill')); ?>

            </a>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-4">
            <div class="card stat-card h-100 border-start border-4 border-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-file-invoice text-primary fa-lg"></i>
                        </div>
                        <span class="text-muted small"><?php echo e(__('Total Expenses')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e(number_format($stats['total_value'], 2)); ?></h3>
                    <div class="text-muted small mt-2"><?php echo e(__('Count')); ?>: <?php echo e($stats['total_count']); ?> <?php echo e(__('Bills')); ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-4">
            <div class="card stat-card h-100 border-start border-4 border-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-check-double text-success fa-lg"></i>
                        </div>
                        <span class="text-muted small text-success"><?php echo e(__('Total Paid')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold text-success"><?php echo e(number_format($stats['paid_value'], 2)); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success"
                            style="width: <?php echo e($stats['total_value'] > 0 ? ($stats['paid_value'] / $stats['total_value']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-4">
            <div class="card stat-card h-100 border-start border-4 border-danger">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-danger bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-hourglass-half text-danger fa-lg"></i>
                        </div>
                        <span class="text-muted small text-danger"><?php echo e(__('Unpaid Balance')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold text-danger"><?php echo e(number_format($stats['pending_value'], 2)); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-danger"
                            style="width: <?php echo e($stats['total_value'] > 0 ? ($stats['pending_value'] / $stats['total_value']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Bill #')); ?></th>
                            <th><?php echo e(__('Supplier')); ?></th>
                            <th class="text-end"><?php echo e(__('Amount')); ?></th>
                            <th class="text-end"><?php echo e(__('Paid')); ?></th>
                            <th class="text-center"><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $bills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Date')); ?>"><?php echo e($bill->date->format('Y-m-d')); ?></td>
                                <td data-label="<?php echo e(__('Bill #')); ?>"><?php echo e($bill->code); ?></td>
                                <td data-label="<?php echo e(__('Supplier')); ?>" class="fw-bold"><?php echo e($bill->supplier->name); ?></td>
                                <td data-label="<?php echo e(__('Amount')); ?>" class="text-end fw-bold">
                                    <?php echo e(number_format($bill->total, 2)); ?></td>
                                <td data-label="<?php echo e(__('Paid')); ?>" class="text-end text-success">
                                    <?php echo e(number_format($bill->paid_amount, 2)); ?></td>
                                <td data-label="<?php echo e(__('Status')); ?>" class="text-center">
                                    <?php if($bill->status == 'paid'): ?>
                                        <span class="badge bg-success"><?php echo e(__('paid')); ?></span>
                                    <?php elseif($bill->status == 'partial'): ?>
                                        <span class="badge bg-warning text-dark"><?php echo e(__('partial')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(__('unpaid')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>">
                                    <a href="<?php echo e(route('accounting.bills.show', $bill)); ?>" class="btn btn-sm btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <i class="fas fa-file-invoice fa-3x text-muted mb-3"></i>
                                    <h3><?php echo e(__('No bills recorded')); ?></h3>
                                    <p class="text-muted"><?php echo e(__('Record your expenses and purchase invoices here.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($bills->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($bills->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/bills/index.blade.php ENDPATH**/ ?>