

<?php $__env->startSection('content'); ?>
    <div class="row mb-4 align-items-center">
        <div class="col-12 col-lg-4 mb-2 mb-lg-0">
            <h2 class="fw-light mb-0"><?php echo e(__('Customers')); ?></h2>
            <p class="text-muted small mb-0 d-none d-lg-block"><?php echo e(__('Manage client relationships and sync with WHMCS')); ?>

            </p>
        </div>
        <div class="col-12 col-lg-8 text-lg-end">
            <div class="d-flex flex-wrap gap-2 justify-content-start justify-content-lg-end">
                <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary shadow-sm">
                    <i class="fas fa-plus-circle me-1"></i><span
                        class="d-none d-sm-inline"><?php echo e(__('New Customer')); ?></span><span
                        class="d-sm-none"><?php echo e(__('New')); ?></span>
                </a>
                <form action="<?php echo e(route('customers.sync-whmcs')); ?>" method="POST" class="d-inline-block">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-outline-info">
                        <i class="fas fa-sync me-1"></i><span class="d-none d-md-inline"><?php echo e(__('Sync WHMCS')); ?></span>
                    </button>
                </form>
                <a href="<?php echo e(route('customers.export')); ?>" class="btn btn-outline-success">
                    <i class="fas fa-file-export me-1"></i><span class="d-none d-md-inline"><?php echo e(__('Export')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Row -->
    <div class="row mb-4 g-3">
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-users text-primary fa-lg"></i>
                        </div>
                        <span class="text-muted small"><?php echo e(__('Total')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e($stats['total']); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-primary" style="width: 100%"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-success bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-user-check text-success fa-lg"></i>
                        </div>
                        <span class="text-muted small text-success"><?php echo e(__('Active')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e($stats['active']); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success"
                            style="width: <?php echo e($stats['total'] > 0 ? ($stats['active'] / $stats['total']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-warning bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-user-clock text-warning fa-lg"></i>
                        </div>
                        <span class="text-muted small text-warning"><?php echo e(__('Inactive')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e($stats['inactive']); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-warning"
                            style="width: <?php echo e($stats['total'] > 0 ? ($stats['inactive'] / $stats['total']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="card stat-card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="bg-danger bg-opacity-10 p-2 rounded-3">
                            <i class="fas fa-user-slash text-danger fa-lg"></i>
                        </div>
                        <span class="text-muted small text-danger"><?php echo e(__('Suspended')); ?></span>
                    </div>
                    <h3 class="mb-0 fw-bold"><?php echo e($stats['suspended']); ?></h3>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-danger"
                            style="width: <?php echo e($stats['total'] > 0 ? ($stats['suspended'] / $stats['total']) * 100 : 0); ?>%">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <form action="<?php echo e(route('customers.index')); ?>" method="GET" class="row g-2">
                <div class="col-12 col-md-4 col-lg-3">
                    <div class="input-group">
                        <span class="input-group-text bg-dark border-secondary text-light"><i
                                class="fas fa-search"></i></span>
                        <input type="text" class="form-control" name="search" placeholder="<?php echo e(__('Search...')); ?>"
                            value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(__('Status')); ?></option>
                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?>

                        </option>
                        <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?>

                        </option>
                        <option value="suspended" <?php echo e(request('status') == 'suspended' ? 'selected' : ''); ?>>
                            <?php echo e(__('Suspended')); ?>

                        </option>
                    </select>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <select name="source" class="form-select">
                        <option value=""><?php echo e(__('Source')); ?></option>
                        <option value="manual" <?php echo e(request('source') == 'manual' ? 'selected' : ''); ?>><?php echo e(__('Manual')); ?>

                        </option>
                        <option value="whmcs" <?php echo e(request('source') == 'whmcs' ? 'selected' : ''); ?>><?php echo e(__('WHMCS')); ?></option>
                    </select>
                </div>
                <div class="col-6 col-md-6 col-lg-2">
                    <select name="sort_by" class="form-select">
                        <option value="created_at" <?php echo e(request('sort_by') == 'created_at' ? 'selected' : ''); ?>><?php echo e(__('Date')); ?>

                        </option>
                        <option value="name" <?php echo e(request('sort_by') == 'name' ? 'selected' : ''); ?>><?php echo e(__('Name')); ?></option>
                        <option value="customer_number" <?php echo e(request('sort_by') == 'customer_number' ? 'selected' : ''); ?>>
                            <?php echo e(__('ID')); ?>

                        </option>
                    </select>
                </div>
                <div class="col-6 col-md-6 col-lg-2">
                    <select name="sort_order" class="form-select">
                        <option value="desc" <?php echo e(request('sort_order') == 'desc' ? 'selected' : ''); ?>><?php echo e(__('Desc')); ?></option>
                        <option value="asc" <?php echo e(request('sort_order') == 'asc' ? 'selected' : ''); ?>><?php echo e(__('Asc')); ?></option>
                    </select>
                </div>
                <div class="col-12 col-lg-1">
                    <button type="submit" class="btn btn-secondary w-100"><i class="fas fa-filter"></i></button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-striped mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th scope="col">
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'customer_number', 'sort_order' => request('sort_by') == 'customer_number' && request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                    class="text-white text-decoration-none d-flex align-items-center gap-1">
                                    <?php echo e(__('ID')); ?>

                                    <?php if(request('sort_by') == 'customer_number'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?> small"></i>
                                    <?php else: ?>
                                        <i class="fas fa-sort text-muted small opacity-50"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th scope="col">
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'name', 'sort_order' => request('sort_by') == 'name' && request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                    class="text-white text-decoration-none d-flex align-items-center gap-1">
                                    <?php echo e(__('Name')); ?>

                                    <?php if(request('sort_by') == 'name'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?> small"></i>
                                    <?php else: ?>
                                        <i class="fas fa-sort text-muted small opacity-50"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th class="d-none d-lg-table-cell"><?php echo e(__('Contact')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Balance')); ?></th>
                            <th class="d-none d-xl-table-cell"><?php echo e(__('Source')); ?></th>
                            <th class="d-none d-xl-table-cell" scope="col">
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'created_at', 'sort_order' => request('sort_by') == 'created_at' && request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                    class="text-white text-decoration-none d-flex align-items-center gap-1">
                                    <?php echo e(__('Created')); ?>

                                    <?php if(request('sort_by') == 'created_at'): ?>
                                        <i class="fas fa-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?> small"></i>
                                    <?php else: ?>
                                        <i class="fas fa-sort text-muted small opacity-50"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th class="text-end"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('ID')); ?>">
                                    <?php if($customer->whmcs_id): ?>
                                        <span class="text-info">#<?php echo e($customer->customer_number); ?></span>
                                    <?php else: ?>
                                        #<?php echo e($customer->customer_number); ?>

                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Name')); ?>">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar me-2 bg-secondary rounded-circle d-flex align-items-center justify-content-center"
                                            style="width: 35px; height: 35px">
                                            <?php echo e(substr($customer->name, 0, 1)); ?>

                                        </div>
                                        <div>
                                            <div class="fw-bold"><?php echo e($customer->name); ?></div>
                                            <?php if($customer->company): ?>
                                                <div class="small text-muted"><?php echo e($customer->company); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td data-label="<?php echo e(__('Contact')); ?>" class="d-none d-lg-table-cell">
                                    <div><i class="fas fa-envelope me-1 text-muted"></i> <?php echo e($customer->email); ?></div>
                                    <?php if($customer->phone): ?>
                                        <div><i class="fas fa-phone me-1 text-muted"></i> <?php echo e($customer->phone); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Status')); ?>">
                                    <span class="badge bg-<?php echo e($customer->status_color); ?>"><?php echo e(__($customer->status)); ?></span>
                                </td>
                                <td data-label="<?php echo e(__('Balance')); ?>">
                                    <div class="mb-1">
                                        <small class="text-muted d-block"><?php echo e(__('Debt')); ?>:</small>
                                        <span class="fw-bold text-danger"><?php echo e(number_format($customer->total_debt, 2)); ?></span>
                                    </div>
                                    <div>
                                        <small class="text-muted d-block"><?php echo e(__('Wallet')); ?>:</small>
                                        <span
                                            class="fw-bold text-success"><?php echo e(number_format($customer->wallet_balance, 2)); ?></span>
                                    </div>
                                </td>
                                <td data-label="<?php echo e(__('Source')); ?>" class="d-none d-xl-table-cell">
                                    <?php if($customer->source == 'whmcs'): ?>
                                        <span class="badge bg-info text-dark"><?php echo e(__('WHMCS')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(__('Manual')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Created')); ?>" class="d-none d-xl-table-cell">
                                    <?php echo e($customer->created_at->format('Y-m-d')); ?>

                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>" class="text-end">
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('customers.show', $customer)); ?>" class="btn btn-sm btn-outline-light"
                                            title="<?php echo e(__('View')); ?>"><i class="fas fa-eye"></i></a>
                                        <a href="<?php echo e(route('customers.edit', $customer)); ?>" class="btn btn-sm btn-outline-light"
                                            title="<?php echo e(__('Edit')); ?>"><i class="fas fa-edit"></i></a>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete customers')): ?>
                                            <form action="<?php echo e(route('customers.destroy', $customer)); ?>" method="POST"
                                                class="d-inline"
                                                onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this customer?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger"
                                                    title="<?php echo e(__('Delete')); ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="text-muted mb-3"><i class="fas fa-users-slash fa-3x"></i></div>
                                    <h5><?php echo e(__('No customers found')); ?></h5>
                                    <p class="text-muted"><?php echo e(__('Try adjusting your filters or create a new customer.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($customers->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($customers->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/customers/index.blade.php ENDPATH**/ ?>