

<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="h4 mb-0"><?php echo e(__('Roles')); ?></h2>
            <a href="<?php echo e(route('settings.roles.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus me-1"></i> <?php echo e(__('Add')); ?>

            </a>
        </div>

        <div class="card glass-card border-0 shadow-sm">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light text-muted small text-uppercase">
                        <tr>
                            <th class="px-4"><?php echo e(__('Role Name')); ?></th>
                            <th><?php echo e(__('Permissions')); ?></th>
                            <th class="text-end px-4"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-4">
                                    <span class="fw-bold text-primary"><?php echo e(strtoupper($role->name)); ?></span>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-1">
                                        <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span
                                                class="badge bg-secondary-soft text-secondary small"><?php echo e($permission->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </td>
                                <td class="text-end px-4">
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('settings.roles.edit', $role)); ?>" class="btn btn-sm btn-light border">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php if($role->name !== 'admin'): ?>
                                            <form action="<?php echo e(route('settings.roles.destroy', $role)); ?>" method="POST"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-light border text-danger"
                                                    onclick="return confirm('<?php echo e(__('Are you sure?')); ?>')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/settings/roles/index.blade.php ENDPATH**/ ?>