

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12 col-md-6">
            <h2 class="fw-light"><?php echo e($treasury->name); ?></h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a
                            href="<?php echo e(route('accounting.treasuries.index')); ?>"><?php echo e(__('Treasuries')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($treasury->name); ?></li>
                </ol>
            </nav>
        </div>
    </div>
    <div class="col-12 col-md-6 text-md-end">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#transactionModal">
            <i class="fas fa-plus-circle me-2"></i>New Transaction
        </button>
    </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-primary text-white">
                <div class="card-body p-4 text-center">
                    <h5 class="text-uppercase opacity-75">Current Balance</h5>
                    <h1 class="display-4 fw-bold mb-0"><?php echo e(number_format($treasury->balance, 2)); ?> <small
                            class="fs-4"><?php echo e($treasury->currency); ?></small></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Transaction History</h5>
            <!-- Filters could go here -->
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th>Ref. No</th>
                            <th class="text-end">Amount</th>
                            <th>User</th>
                            <th class="text-center">Voucher</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($transaction->date->format('Y-m-d')); ?></td>
                                <td>
                                    <?php if($transaction->type == 'in'): ?>
                                        <span class="badge bg-success"><i class="fas fa-arrow-down me-1"></i> Deposit</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><i class="fas fa-arrow-up me-1"></i> Widthdrawal</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($transaction->description); ?>

                                    <?php if($transaction->model_type == 'App\Models\Invoice'): ?>
                                        <a href="<?php echo e(route('accounting.invoices.show', $transaction->model_id)); ?>"
                                            class="text-info ms-1"><i class="fas fa-link"></i></a>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($transaction->ref_no ?? '-'); ?></td>
                                <td class="text-end fw-bold <?php echo e($transaction->type == 'in' ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e($transaction->type == 'in' ? '+' : '-'); ?> <?php echo e(number_format($transaction->amount, 2)); ?>

                                </td>
                                <td>
                                    <small class="text-muted"><?php echo e($transaction->user->name ?? 'System'); ?></small>
                                </td>
                                <td class="text-center">
                                    <a href="<?php echo e(route('accounting.treasuries.vouchers.print', $transaction)); ?>" target="_blank"
                                        class="text-info">
                                        <i class="fas fa-print"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">No transactions found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($transactions->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($transactions->links()); ?>

            </div>
        <?php endif; ?>
    </div>
    </div>

    <!-- Transaction Modal -->
    <div class="modal fade" id="transactionModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="<?php echo e(route('accounting.treasuries.transaction')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="treasury_id" value="<?php echo e($treasury->id); ?>">
                <div class="modal-content bg-dark">
                    <div class="modal-header border-secondary">
                        <h5 class="modal-title">New Transaction</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Type <span class="text-danger">*</span></label>
                            <div class="btn-group w-100" role="group">
                                <input type="radio" class="btn-check" name="type" id="typeIn" value="in" autocomplete="off"
                                    checked>
                                <label class="btn btn-outline-success" for="typeIn">Deposit (Income)</label>

                                <input type="radio" class="btn-check" name="type" id="typeOut" value="out"
                                    autocomplete="off">
                                <label class="btn btn-outline-danger" for="typeOut">Withdrawal (Expense)</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Amount <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="amount" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Date <span class="text-danger">*</span></label>
                            <input type="date" name="date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description <span class="text-danger">*</span></label>
                            <input type="text" name="description" class="form-control"
                                placeholder="e.g. Electricity Bill, Cash Sale" required>
                        </div>
                    </div>
                    <div class="modal-footer border-secondary">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save Transaction</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/treasuries/show.blade.php ENDPATH**/ ?>