

<?php $__env->startSection('content'); ?>
    <!-- Page Header -->
    <div class="page-header d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
        <div>
            <h1 class="page-title"><?php echo e(__('Suppliers')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Manage your vendors and track payable amounts')); ?></p>
        </div>
        <a href="<?php echo e(route('accounting.suppliers.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus-circle me-2"></i><?php echo e(__('New Supplier')); ?>

        </a>
    </div>

    <!-- Stats Row -->
    <div class="row g-4 mb-4">
        <div class="col-6 col-lg-3">
            <div class="stat-card orange">
                <div class="stat-icon"><i class="fas fa-truck"></i></div>
                <div class="stat-value"><?php echo e($suppliers->total()); ?></div>
                <div class="stat-label"><?php echo e(__('Total Suppliers')); ?></div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card pink">
                <div class="stat-icon"><i class="fas fa-coins"></i></div>
                <div class="stat-value"><?php echo e(number_format($suppliers->sum(function ($s) {
        return $s->balance * ($s->currency->exchange_rate ?? 1);
    }), 2)); ?></div>
                <div class="stat-label"><?php echo e(__('Total Payable (Base Currency)')); ?></div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card green">
                <div class="stat-icon"><i class="fas fa-check-circle"></i></div>
                <div class="stat-value"><?php echo e($suppliers->where('balance', 0)->count()); ?></div>
                <div class="stat-label"><?php echo e(__('Settled')); ?></div>
            </div>
        </div>
        <div class="col-6 col-lg-3">
            <div class="stat-card purple">
                <div class="stat-icon"><i class="fas fa-exclamation-triangle"></i></div>
                <div class="stat-value"><?php echo e($suppliers->where('balance', '>', 0)->count()); ?></div>
                <div class="stat-label"><?php echo e(__('With Balance')); ?></div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive table-responsive-stack">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-dark">
                        <tr>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Mobile')); ?></th>
                            <th><?php echo e(__('Tax ID')); ?></th>
                            <th><?php echo e(__('Balance (Due)')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo e(__('Name')); ?>" class="fw-bold">
                                    <?php echo e($supplier->name); ?>

                                    <?php if($supplier->email): ?>
                                        <br><small class="text-muted"><?php echo e($supplier->email); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo e(__('Mobile')); ?>"><?php echo e($supplier->phone ?? '-'); ?></td>
                                <td data-label="<?php echo e(__('Tax ID')); ?>"><?php echo e($supplier->tax_id ?? '-'); ?></td>
                                <td data-label="<?php echo e(__('Balance (Due)')); ?>" class="fw-bold text-danger">
                                    <?php echo e(number_format($supplier->balance, 2)); ?> <?php echo e($supplier->currency->code ?? 'EGP'); ?>

                                </td>
                                <td data-label="<?php echo e(__('Actions')); ?>">
                                    <div class="d-flex gap-1">
                                        <a href="<?php echo e(route('accounting.suppliers.show', $supplier)); ?>"
                                            class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('accounting.suppliers.edit', $supplier)); ?>"
                                            class="btn btn-sm btn-outline-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <i class="fas fa-truck fa-3x text-muted mb-3"></i>
                                    <h3><?php echo e(__('No suppliers found')); ?></h3>
                                    <p class="text-muted"><?php echo e(__('Register your vendors to track expenses.')); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($suppliers->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($suppliers->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\code\resources\views/accounting/suppliers/index.blade.php ENDPATH**/ ?>